/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verantwortlicher für die Baustelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdBaustellenVerantwortlicher extends AbstractParameterDatensatz<PdBaustellenVerantwortlicher.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _firma
				= new String
				()
				;
				private String
				 _telefonFirma
				= new String
				()
				;
				private String
				 _nameBaustellenVerantwortlicher
				= new String
				()
				;
				private String
				 _telefonBaustellenVerantwortlicher
				= new String
				()
				;
				private String
				 _telefonMobilBaustellenVerantwortlicher
				= new String
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Name der verantwortlichen Firma.
			<p>
			
			</p>
			
			@return der Wert von Firma.
			*/
				public String
				 getFirma() {
				return _firma;
			}
		
			/**
			Name der verantwortlichen Firma.
			<p>
			
			</p>
			
			@param _firma der neue Wert von Firma.
			*/
			public void setFirma(String
			 _firma) {
				if (_firma.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._firma = _firma;
			}
		
			/**
			Telefonnummer der verantwortlichen Firma.
			<p>
			
			</p>
			
			@return der Wert von TelefonFirma.
			*/
				public String
				 getTelefonFirma() {
				return _telefonFirma;
			}
		
			/**
			Telefonnummer der verantwortlichen Firma.
			<p>
			
			</p>
			
			@param _telefonFirma der neue Wert von TelefonFirma.
			*/
			public void setTelefonFirma(String
			 _telefonFirma) {
				if (_telefonFirma.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._telefonFirma = _telefonFirma;
			}
		
			/**
			Name des Baustellenverantwortlichen.
			<p>
			
			</p>
			
			@return der Wert von NameBaustellenVerantwortlicher.
			*/
				public String
				 getNameBaustellenVerantwortlicher() {
				return _nameBaustellenVerantwortlicher;
			}
		
			/**
			Name des Baustellenverantwortlichen.
			<p>
			
			</p>
			
			@param _nameBaustellenVerantwortlicher der neue Wert von NameBaustellenVerantwortlicher.
			*/
			public void setNameBaustellenVerantwortlicher(String
			 _nameBaustellenVerantwortlicher) {
				if (_nameBaustellenVerantwortlicher.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._nameBaustellenVerantwortlicher = _nameBaustellenVerantwortlicher;
			}
		
			/**
			Telefonnummer des Baustellenverantwortlichen.
			<p>
			
			</p>
			
			@return der Wert von TelefonBaustellenVerantwortlicher.
			*/
				public String
				 getTelefonBaustellenVerantwortlicher() {
				return _telefonBaustellenVerantwortlicher;
			}
		
			/**
			Telefonnummer des Baustellenverantwortlichen.
			<p>
			
			</p>
			
			@param _telefonBaustellenVerantwortlicher der neue Wert von TelefonBaustellenVerantwortlicher.
			*/
			public void setTelefonBaustellenVerantwortlicher(String
			 _telefonBaustellenVerantwortlicher) {
				if (_telefonBaustellenVerantwortlicher.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._telefonBaustellenVerantwortlicher = _telefonBaustellenVerantwortlicher;
			}
		
			/**
			Mobiltelefonnummer des
									Baustellenverantwortlichen.
			<p>
			
			</p>
			
			@return der Wert von TelefonMobilBaustellenVerantwortlicher.
			*/
				public String
				 getTelefonMobilBaustellenVerantwortlicher() {
				return _telefonMobilBaustellenVerantwortlicher;
			}
		
			/**
			Mobiltelefonnummer des
									Baustellenverantwortlichen.
			<p>
			
			</p>
			
			@param _telefonMobilBaustellenVerantwortlicher der neue Wert von TelefonMobilBaustellenVerantwortlicher.
			*/
			public void setTelefonMobilBaustellenVerantwortlicher(String
			 _telefonMobilBaustellenVerantwortlicher) {
				if (_telefonMobilBaustellenVerantwortlicher.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._telefonMobilBaustellenVerantwortlicher = _telefonMobilBaustellenVerantwortlicher;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getFirma() != null) {
						datum.getTextValue("Firma").setText(getFirma());
					}
					// ZeichenkettenAttributTyp
					if (getTelefonFirma() != null) {
						datum.getTextValue("TelefonFirma").setText(getTelefonFirma());
					}
					// ZeichenkettenAttributTyp
					if (getNameBaustellenVerantwortlicher() != null) {
						datum.getTextValue("NameBaustellenVerantwortlicher").setText(getNameBaustellenVerantwortlicher());
					}
					// ZeichenkettenAttributTyp
					if (getTelefonBaustellenVerantwortlicher() != null) {
						datum.getTextValue("TelefonBaustellenVerantwortlicher").setText(getTelefonBaustellenVerantwortlicher());
					}
					// ZeichenkettenAttributTyp
					if (getTelefonMobilBaustellenVerantwortlicher() != null) {
						datum.getTextValue("TelefonMobilBaustellenVerantwortlicher").setText(getTelefonMobilBaustellenVerantwortlicher());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setFirma(daten.getTextValue("Firma").getText());
					// ZeichenkettenAttributTyp
						setTelefonFirma(daten.getTextValue("TelefonFirma").getText());
					// ZeichenkettenAttributTyp
						setNameBaustellenVerantwortlicher(daten.getTextValue("NameBaustellenVerantwortlicher").getText());
					// ZeichenkettenAttributTyp
						setTelefonBaustellenVerantwortlicher(daten.getTextValue("TelefonBaustellenVerantwortlicher").getText());
					// ZeichenkettenAttributTyp
						setTelefonMobilBaustellenVerantwortlicher(daten.getTextValue("TelefonMobilBaustellenVerantwortlicher").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setFirma(getFirma());
							klon.setTelefonFirma(getTelefonFirma());
							klon.setNameBaustellenVerantwortlicher(getNameBaustellenVerantwortlicher());
							klon.setTelefonBaustellenVerantwortlicher(getTelefonBaustellenVerantwortlicher());
							klon.setTelefonMobilBaustellenVerantwortlicher(getTelefonMobilBaustellenVerantwortlicher());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.baustellenVerantwortlicher";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdBaustellenVerantwortlicher(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
