/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter eines Fundamentaldiagramms.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdFundamentalDiagramm extends AbstractParameterDatensatz<PdFundamentalDiagramm.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
				 _q0
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _k0
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v0
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vFrei
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Q0 Verkehrsmenge des Fundamentaldiagramms.
			<p>
			
			</p>
			
			@return der Wert von Q0.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
				 getQ0() {
				return _q0;
			}
		
			/**
			Q0 Verkehrsmenge des Fundamentaldiagramms.
			<p>
			
			</p>
			
			@param _q0 der neue Wert von Q0.
			*/
			public void setQ0(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 _q0) {
				this._q0 = _q0;
			}
		
			/**
			Maximale Dichte des Fundamentaldiagramms.
			<p>
			
			</p>
			
			@return der Wert von K0.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getK0() {
				return _k0;
			}
		
			/**
			Maximale Dichte des Fundamentaldiagramms.
			<p>
			
			</p>
			
			@param _k0 der neue Wert von K0.
			*/
			public void setK0(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _k0) {
				this._k0 = _k0;
			}
		
			/**
			V0-Geschwindigkeit des Fundamentaldiagramms.
			<p>
			
			</p>
			
			@return der Wert von V0.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV0() {
				return _v0;
			}
		
			/**
			V0-Geschwindigkeit des Fundamentaldiagramms.
			<p>
			
			</p>
			
			@param _v0 der neue Wert von V0.
			*/
			public void setV0(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v0) {
				this._v0 = _v0;
			}
		
			/**
			Freie Geschwindigkeit des Fundamentaldiagramms.
			<p>
			
			</p>
			
			@return der Wert von VFrei.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVFrei() {
				return _vFrei;
			}
		
			/**
			Freie Geschwindigkeit des Fundamentaldiagramms.
			<p>
			
			</p>
			
			@param _vFrei der neue Wert von VFrei.
			*/
			public void setVFrei(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vFrei) {
				this._vFrei = _vFrei;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getQ0() != null) {
		                if (getQ0().isZustand()) {
		                    datum.getUnscaledValue("Q0").setText(getQ0().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Q0").set(getQ0().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getK0() != null) {
		                if (getK0().isZustand()) {
		                    datum.getUnscaledValue("K0").setText(getK0().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("K0").set(getK0().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV0() != null) {
		                if (getV0().isZustand()) {
		                    datum.getUnscaledValue("V0").setText(getV0().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("V0").set(getV0().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVFrei() != null) {
		                if (getVFrei().isZustand()) {
		                    datum.getUnscaledValue("VFrei").setText(getVFrei().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VFrei").set(getVFrei().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Q0").isState()) {
								setQ0(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("Q0").getText()));
							} else {
							setQ0(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("Q0").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("K0").isState()) {
								setK0(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("K0").getText()));
							} else {
							setK0(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("K0").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("V0").isState()) {
								setV0(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("V0").getText()));
							} else {
							setV0(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("V0").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VFrei").isState()) {
								setVFrei(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("VFrei").getText()));
							} else {
							setVFrei(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("VFrei").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setQ0(getQ0());
							klon.setK0(getK0());
							klon.setV0(getV0());
							klon.setVFrei(getVFrei());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.fundamentalDiagramm";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdFundamentalDiagramm(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
