/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Modellparameter für die Stauobjektbestimmung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdStauBestimmungModell extends AbstractParameterDatensatz<PdStauBestimmungModell.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 _zykluszeit
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				> _sIVerfahren = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStauAnfangsLaenge
				 _anfangslaenge
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _stromabVerlaengerung
				;
				@Defaultwert(wert = "1000")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
				 _maxSIAbstand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
				 _teilungslaenge
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 _teilungsverzoegerung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _prognoselaengeA1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _prognoselaengeA2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _prognoselaengeA3
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _minSIGuete
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Zykluszeit der Stauobjektbestimmung in Sekunden.
			<p>
			
			</p>
			
			@return der Wert von Zykluszeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 getZykluszeit() {
				return _zykluszeit;
			}
		
			/**
			Zykluszeit der Stauobjektbestimmung in Sekunden.
			<p>
			
			</p>
			
			@param _zykluszeit der neue Wert von Zykluszeit.
			*/
			public void setZykluszeit(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _zykluszeit) {
				this._zykluszeit = _zykluszeit;
			}
		
			/**
			Liste der Verfahren deren Störfallindikatoren
									berücksichtigt werden sollen.
			<p>
			
			</p>
			
			@return der Wert von SIVerfahren.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				> getSIVerfahren() {
				return _sIVerfahren;
			}
		
		
			/**
			Angenommene Anfangslänge des gestauten Bereichs
									an einem lokalen Störfallindikator pro Minute
									des jeweiligen Erfassungszyklus.
			<p>
			
			</p>
			
			@return der Wert von Anfangslaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStauAnfangsLaenge
				 getAnfangslaenge() {
				return _anfangslaenge;
			}
		
			/**
			Angenommene Anfangslänge des gestauten Bereichs
									an einem lokalen Störfallindikator pro Minute
									des jeweiligen Erfassungszyklus.
			<p>
			
			</p>
			
			@param _anfangslaenge der neue Wert von Anfangslaenge.
			*/
			public void setAnfangslaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStauAnfangsLaenge
			 _anfangslaenge) {
				this._anfangslaenge = _anfangslaenge;
			}
		
			/**
			Angenommene Verlängerung der Anfangslänge bei
									gestautem Infrastrukturobjekt i an einem lokalen
									Störfallindikator.
			<p>
			
			</p>
			
			@return der Wert von StromabVerlaengerung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getStromabVerlaengerung() {
				return _stromabVerlaengerung;
			}
		
			/**
			Angenommene Verlängerung der Anfangslänge bei
									gestautem Infrastrukturobjekt i an einem lokalen
									Störfallindikator.
			<p>
			
			</p>
			
			@param _stromabVerlaengerung der neue Wert von StromabVerlaengerung.
			*/
			public void setStromabVerlaengerung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _stromabVerlaengerung) {
				this._stromabVerlaengerung = _stromabVerlaengerung;
			}
		
			/**
			Maximalabstand für die Zusammenfassung von
									gestauten Bereichen (Standard 1000 Meter).
			<p>
			
			</p>
			
			@return der Wert von MaxSIAbstand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
				 getMaxSIAbstand() {
				return _maxSIAbstand;
			}
		
			/**
			Maximalabstand für die Zusammenfassung von
									gestauten Bereichen (Standard 1000 Meter).
			<p>
			
			</p>
			
			@param _maxSIAbstand der neue Wert von MaxSIAbstand.
			*/
			public void setMaxSIAbstand(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
			 _maxSIAbstand) {
				this._maxSIAbstand = _maxSIAbstand;
			}
		
			/**
			Mindestlänge eines ungestauten Bereiches
									innerhalb eines Stauobjektes für die sofortige
									Aufteilung in zwei Stauobjekte.
			<p>
			
			</p>
			
			@return der Wert von Teilungslaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
				 getTeilungslaenge() {
				return _teilungslaenge;
			}
		
			/**
			Mindestlänge eines ungestauten Bereiches
									innerhalb eines Stauobjektes für die sofortige
									Aufteilung in zwei Stauobjekte.
			<p>
			
			</p>
			
			@param _teilungslaenge der neue Wert von Teilungslaenge.
			*/
			public void setTeilungslaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
			 _teilungslaenge) {
				this._teilungslaenge = _teilungslaenge;
			}
		
			/**
			Zeitverzögerung für die Aufteilung eines
									Stauobjekts in dem die Länge eines inneren
									ungestauten Bereiches den Wert "Teilungslänge"
									noch nicht überschreitet.
			<p>
			
			</p>
			
			@return der Wert von Teilungsverzoegerung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 getTeilungsverzoegerung() {
				return _teilungsverzoegerung;
			}
		
			/**
			Zeitverzögerung für die Aufteilung eines
									Stauobjekts in dem die Länge eines inneren
									ungestauten Bereiches den Wert "Teilungslänge"
									noch nicht überschreitet.
			<p>
			
			</p>
			
			@param _teilungsverzoegerung der neue Wert von Teilungsverzoegerung.
			*/
			public void setTeilungsverzoegerung(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _teilungsverzoegerung) {
				this._teilungsverzoegerung = _teilungsverzoegerung;
			}
		
			/**
			Parameter a1 aus der Gleichung für die
									Berechnung der maximalen Verlängerung eines
									Stauobjektes durch die Prognose.
			<p>
			
			</p>
			
			@return der Wert von PrognoselaengeA1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getPrognoselaengeA1() {
				return _prognoselaengeA1;
			}
		
			/**
			Parameter a1 aus der Gleichung für die
									Berechnung der maximalen Verlängerung eines
									Stauobjektes durch die Prognose.
			<p>
			
			</p>
			
			@param _prognoselaengeA1 der neue Wert von PrognoselaengeA1.
			*/
			public void setPrognoselaengeA1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _prognoselaengeA1) {
				this._prognoselaengeA1 = _prognoselaengeA1;
			}
		
			/**
			Parameter a2 aus der Gleichung für die
									Berechnung der maximalen Verlängerung eines
									Stauobjektes durch die Prognose.
			<p>
			
			</p>
			
			@return der Wert von PrognoselaengeA2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getPrognoselaengeA2() {
				return _prognoselaengeA2;
			}
		
			/**
			Parameter a2 aus der Gleichung für die
									Berechnung der maximalen Verlängerung eines
									Stauobjektes durch die Prognose.
			<p>
			
			</p>
			
			@param _prognoselaengeA2 der neue Wert von PrognoselaengeA2.
			*/
			public void setPrognoselaengeA2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _prognoselaengeA2) {
				this._prognoselaengeA2 = _prognoselaengeA2;
			}
		
			/**
			Parameter a3 aus der Gleichung für die
									Berechnung der maximalen Verlängerung eines
									Stauobjektes durch die Prognose.
			<p>
			
			</p>
			
			@return der Wert von PrognoselaengeA3.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getPrognoselaengeA3() {
				return _prognoselaengeA3;
			}
		
			/**
			Parameter a3 aus der Gleichung für die
									Berechnung der maximalen Verlängerung eines
									Stauobjektes durch die Prognose.
			<p>
			
			</p>
			
			@param _prognoselaengeA3 der neue Wert von PrognoselaengeA3.
			*/
			public void setPrognoselaengeA3(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _prognoselaengeA3) {
				this._prognoselaengeA3 = _prognoselaengeA3;
			}
		
			/**
			Minimale Güte von zu berücksichtigenden
									Störfallindikatoren.
			<p>
			
			</p>
			
			@return der Wert von MinSIGuete.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getMinSIGuete() {
				return _minSIGuete;
			}
		
			/**
			Minimale Güte von zu berücksichtigenden
									Störfallindikatoren.
			<p>
			
			</p>
			
			@param _minSIGuete der neue Wert von MinSIGuete.
			*/
			public void setMinSIGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _minSIGuete) {
				this._minSIGuete = _minSIGuete;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getZykluszeit() != null) {
		                if (getZykluszeit().isZustand()) {
		                    datum.getUnscaledValue("Zykluszeit").setText(getZykluszeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Zykluszeit").set(getZykluszeit().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arraySIVerfahren = datum.getReferenceArray("SIVerfahren");
						arraySIVerfahren.setLength(getSIVerfahren().size());
						for (int i = 0; i < arraySIVerfahren.getLength(); ++i) {
							final Object soSIVerfahren = getSIVerfahren().get(i);
							final SystemObject tmpSIVerfahren;
							if (soSIVerfahren instanceof SystemObject) {
								tmpSIVerfahren = (SystemObject)soSIVerfahren;
							} else if(soSIVerfahren instanceof SystemObjekt){
								tmpSIVerfahren = ((SystemObjekt)soSIVerfahren).getSystemObject();
							} else{
								tmpSIVerfahren = null;
							}
							arraySIVerfahren.getReferenceValue(i).setSystemObject(tmpSIVerfahren);
						}
					// GanzzahlAttributTyp
					if (getAnfangslaenge() != null) {
		                if (getAnfangslaenge().isZustand()) {
		                    datum.getUnscaledValue("Anfangslaenge").setText(getAnfangslaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Anfangslaenge").set(getAnfangslaenge().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStromabVerlaengerung() != null) {
		                if (getStromabVerlaengerung().isZustand()) {
		                    datum.getUnscaledValue("StromabVerlaengerung").setText(getStromabVerlaengerung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StromabVerlaengerung").set(getStromabVerlaengerung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxSIAbstand() != null) {
		                if (getMaxSIAbstand().isZustand()) {
		                    datum.getUnscaledValue("MaxSIAbstand").setText(getMaxSIAbstand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxSIAbstand").set(getMaxSIAbstand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTeilungslaenge() != null) {
		                if (getTeilungslaenge().isZustand()) {
		                    datum.getUnscaledValue("Teilungslaenge").setText(getTeilungslaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Teilungslaenge").set(getTeilungslaenge().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTeilungsverzoegerung() != null) {
		                if (getTeilungsverzoegerung().isZustand()) {
		                    datum.getUnscaledValue("Teilungsverzoegerung").setText(getTeilungsverzoegerung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Teilungsverzoegerung").set(getTeilungsverzoegerung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrognoselaengeA1() != null) {
		                if (getPrognoselaengeA1().isZustand()) {
		                    datum.getUnscaledValue("PrognoselaengeA1").setText(getPrognoselaengeA1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoselaengeA1").set(getPrognoselaengeA1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrognoselaengeA2() != null) {
		                if (getPrognoselaengeA2().isZustand()) {
		                    datum.getUnscaledValue("PrognoselaengeA2").setText(getPrognoselaengeA2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoselaengeA2").set(getPrognoselaengeA2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrognoselaengeA3() != null) {
		                if (getPrognoselaengeA3().isZustand()) {
		                    datum.getUnscaledValue("PrognoselaengeA3").setText(getPrognoselaengeA3().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoselaengeA3").set(getPrognoselaengeA3().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMinSIGuete() != null) {
		                if (getMinSIGuete().isZustand()) {
		                    datum.getUnscaledValue("MinSIGuete").setText(getMinSIGuete().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MinSIGuete").set(getMinSIGuete().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							setZykluszeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
							(daten.
								getUnscaledValue
							("Zykluszeit").
									longValue
							()));
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arraySIVerfahren = daten.getReferenceArray("SIVerfahren");
						for (int i = 0; i < arraySIVerfahren.getLength(); ++i) {
							final long idSIVerfahren = daten.getReferenceArray("SIVerfahren").getReferenceValue(i).getId();
							final SystemObjekt tmpSIVerfahren;
							if (idSIVerfahren == 0) {
								tmpSIVerfahren = null;
							} else {
								final SystemObject soSIVerfahren = factory.getDav().getDataModel().getObject(idSIVerfahren);
								if (soSIVerfahren == null) {
										tmpSIVerfahren = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idSIVerfahren);
								} else {
									tmpSIVerfahren = factory.getModellobjekt(soSIVerfahren);
								}
							}
								getSIVerfahren().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
								) tmpSIVerfahren);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Anfangslaenge").isState()) {
								setAnfangslaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStauAnfangsLaenge
								.getZustand(daten.getScaledValue("Anfangslaenge").getText()));
							} else {
							setAnfangslaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStauAnfangsLaenge
							(daten.
								getUnscaledValue
							("Anfangslaenge").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StromabVerlaengerung").isState()) {
								setStromabVerlaengerung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("StromabVerlaengerung").getText()));
							} else {
							setStromabVerlaengerung(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("StromabVerlaengerung").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxSIAbstand").isState()) {
								setMaxSIAbstand(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
								.getZustand(daten.getScaledValue("MaxSIAbstand").getText()));
							} else {
							setMaxSIAbstand(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
							(daten.
								getUnscaledValue
							("MaxSIAbstand").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Teilungslaenge").isState()) {
								setTeilungslaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
								.getZustand(daten.getScaledValue("Teilungslaenge").getText()));
							} else {
							setTeilungslaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
							(daten.
								getUnscaledValue
							("Teilungslaenge").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							setTeilungsverzoegerung(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
							(daten.
								getUnscaledValue
							("Teilungsverzoegerung").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoselaengeA1").isState()) {
								setPrognoselaengeA1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("PrognoselaengeA1").getText()));
							} else {
							setPrognoselaengeA1(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("PrognoselaengeA1").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoselaengeA2").isState()) {
								setPrognoselaengeA2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("PrognoselaengeA2").getText()));
							} else {
							setPrognoselaengeA2(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("PrognoselaengeA2").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoselaengeA3").isState()) {
								setPrognoselaengeA3(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("PrognoselaengeA3").getText()));
							} else {
							setPrognoselaengeA3(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("PrognoselaengeA3").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MinSIGuete").isState()) {
								setMinSIGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("MinSIGuete").getText()));
							} else {
							setMinSIGuete(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("MinSIGuete").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setZykluszeit(getZykluszeit());
						klon._sIVerfahren = getSIVerfahren().clone();
							klon.setAnfangslaenge(getAnfangslaenge());
							klon.setStromabVerlaengerung(getStromabVerlaengerung());
							klon.setMaxSIAbstand(getMaxSIAbstand());
							klon.setTeilungslaenge(getTeilungslaenge());
							klon.setTeilungsverzoegerung(getTeilungsverzoegerung());
							klon.setPrognoselaengeA1(getPrognoselaengeA1());
							klon.setPrognoselaengeA2(getPrognoselaengeA2());
							klon.setPrognoselaengeA3(getPrognoselaengeA3());
							klon.setMinSIGuete(getMinSIGuete());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.stauBestimmungModell";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdStauBestimmungModell(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
