/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die Differenzialkontrolle von
					Fahrstreifendaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdVerkehrsDatenDifferenzialKontrolleFs extends AbstractParameterDatensatz<PdVerkehrsDatenDifferenzialKontrolleFs.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _maxAnzKonstanzqKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _maxAnzKonstanzqLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _maxAnzKonstanzqPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _maxAnzKonstanzvKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _maxAnzKonstanzvLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _maxAnzKonstanzvPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _maxAnzKonstanzStreung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _maxAnzKonstanzBelegung
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für qKfz.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzKonstanzqKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMaxAnzKonstanzqKfz() {
				return _maxAnzKonstanzqKfz;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für qKfz.
			<p>
			
			</p>
			
			@param _maxAnzKonstanzqKfz der neue Wert von MaxAnzKonstanzqKfz.
			*/
			public void setMaxAnzKonstanzqKfz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxAnzKonstanzqKfz) {
				this._maxAnzKonstanzqKfz = _maxAnzKonstanzqKfz;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für qLkw.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzKonstanzqLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMaxAnzKonstanzqLkw() {
				return _maxAnzKonstanzqLkw;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für qLkw.
			<p>
			
			</p>
			
			@param _maxAnzKonstanzqLkw der neue Wert von MaxAnzKonstanzqLkw.
			*/
			public void setMaxAnzKonstanzqLkw(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxAnzKonstanzqLkw) {
				this._maxAnzKonstanzqLkw = _maxAnzKonstanzqLkw;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für qPkw.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzKonstanzqPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMaxAnzKonstanzqPkw() {
				return _maxAnzKonstanzqPkw;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für qPkw.
			<p>
			
			</p>
			
			@param _maxAnzKonstanzqPkw der neue Wert von MaxAnzKonstanzqPkw.
			*/
			public void setMaxAnzKonstanzqPkw(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxAnzKonstanzqPkw) {
				this._maxAnzKonstanzqPkw = _maxAnzKonstanzqPkw;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für vKfz.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzKonstanzvKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMaxAnzKonstanzvKfz() {
				return _maxAnzKonstanzvKfz;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für vKfz.
			<p>
			
			</p>
			
			@param _maxAnzKonstanzvKfz der neue Wert von MaxAnzKonstanzvKfz.
			*/
			public void setMaxAnzKonstanzvKfz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxAnzKonstanzvKfz) {
				this._maxAnzKonstanzvKfz = _maxAnzKonstanzvKfz;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für vLkw.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzKonstanzvLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMaxAnzKonstanzvLkw() {
				return _maxAnzKonstanzvLkw;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für vLkw.
			<p>
			
			</p>
			
			@param _maxAnzKonstanzvLkw der neue Wert von MaxAnzKonstanzvLkw.
			*/
			public void setMaxAnzKonstanzvLkw(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxAnzKonstanzvLkw) {
				this._maxAnzKonstanzvLkw = _maxAnzKonstanzvLkw;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für vPkw.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzKonstanzvPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMaxAnzKonstanzvPkw() {
				return _maxAnzKonstanzvPkw;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für vPkw.
			<p>
			
			</p>
			
			@param _maxAnzKonstanzvPkw der neue Wert von MaxAnzKonstanzvPkw.
			*/
			public void setMaxAnzKonstanzvPkw(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxAnzKonstanzvPkw) {
				this._maxAnzKonstanzvPkw = _maxAnzKonstanzvPkw;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für die Streung S.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzKonstanzStreung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMaxAnzKonstanzStreung() {
				return _maxAnzKonstanzStreung;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für die Streung S.
			<p>
			
			</p>
			
			@param _maxAnzKonstanzStreung der neue Wert von MaxAnzKonstanzStreung.
			*/
			public void setMaxAnzKonstanzStreung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxAnzKonstanzStreung) {
				this._maxAnzKonstanzStreung = _maxAnzKonstanzStreung;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für die Belegung b.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzKonstanzBelegung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMaxAnzKonstanzBelegung() {
				return _maxAnzKonstanzBelegung;
			}
		
			/**
			Maximal zulässige Anzahl von Intervallen mit
									Ergebniskonstanz für die Belegung b.
			<p>
			
			</p>
			
			@param _maxAnzKonstanzBelegung der neue Wert von MaxAnzKonstanzBelegung.
			*/
			public void setMaxAnzKonstanzBelegung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxAnzKonstanzBelegung) {
				this._maxAnzKonstanzBelegung = _maxAnzKonstanzBelegung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getMaxAnzKonstanzqKfz() != null) {
		                if (getMaxAnzKonstanzqKfz().isZustand()) {
		                    datum.getUnscaledValue("maxAnzKonstanzqKfz").setText(getMaxAnzKonstanzqKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAnzKonstanzqKfz").set(getMaxAnzKonstanzqKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzKonstanzqLkw() != null) {
		                if (getMaxAnzKonstanzqLkw().isZustand()) {
		                    datum.getUnscaledValue("maxAnzKonstanzqLkw").setText(getMaxAnzKonstanzqLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAnzKonstanzqLkw").set(getMaxAnzKonstanzqLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzKonstanzqPkw() != null) {
		                if (getMaxAnzKonstanzqPkw().isZustand()) {
		                    datum.getUnscaledValue("maxAnzKonstanzqPkw").setText(getMaxAnzKonstanzqPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAnzKonstanzqPkw").set(getMaxAnzKonstanzqPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzKonstanzvKfz() != null) {
		                if (getMaxAnzKonstanzvKfz().isZustand()) {
		                    datum.getUnscaledValue("maxAnzKonstanzvKfz").setText(getMaxAnzKonstanzvKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAnzKonstanzvKfz").set(getMaxAnzKonstanzvKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzKonstanzvLkw() != null) {
		                if (getMaxAnzKonstanzvLkw().isZustand()) {
		                    datum.getUnscaledValue("maxAnzKonstanzvLkw").setText(getMaxAnzKonstanzvLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAnzKonstanzvLkw").set(getMaxAnzKonstanzvLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzKonstanzvPkw() != null) {
		                if (getMaxAnzKonstanzvPkw().isZustand()) {
		                    datum.getUnscaledValue("maxAnzKonstanzvPkw").setText(getMaxAnzKonstanzvPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAnzKonstanzvPkw").set(getMaxAnzKonstanzvPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzKonstanzStreung() != null) {
		                if (getMaxAnzKonstanzStreung().isZustand()) {
		                    datum.getUnscaledValue("maxAnzKonstanzStreung").setText(getMaxAnzKonstanzStreung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAnzKonstanzStreung").set(getMaxAnzKonstanzStreung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzKonstanzBelegung() != null) {
		                if (getMaxAnzKonstanzBelegung().isZustand()) {
		                    datum.getUnscaledValue("maxAnzKonstanzBelegung").setText(getMaxAnzKonstanzBelegung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAnzKonstanzBelegung").set(getMaxAnzKonstanzBelegung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							setMaxAnzKonstanzqKfz(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("maxAnzKonstanzqKfz").
									longValue
							()));
					// GanzzahlAttributTyp
							setMaxAnzKonstanzqLkw(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("maxAnzKonstanzqLkw").
									longValue
							()));
					// GanzzahlAttributTyp
							setMaxAnzKonstanzqPkw(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("maxAnzKonstanzqPkw").
									longValue
							()));
					// GanzzahlAttributTyp
							setMaxAnzKonstanzvKfz(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("maxAnzKonstanzvKfz").
									longValue
							()));
					// GanzzahlAttributTyp
							setMaxAnzKonstanzvLkw(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("maxAnzKonstanzvLkw").
									longValue
							()));
					// GanzzahlAttributTyp
							setMaxAnzKonstanzvPkw(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("maxAnzKonstanzvPkw").
									longValue
							()));
					// GanzzahlAttributTyp
							setMaxAnzKonstanzStreung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("maxAnzKonstanzStreung").
									longValue
							()));
					// GanzzahlAttributTyp
							setMaxAnzKonstanzBelegung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("maxAnzKonstanzBelegung").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setMaxAnzKonstanzqKfz(getMaxAnzKonstanzqKfz());
							klon.setMaxAnzKonstanzqLkw(getMaxAnzKonstanzqLkw());
							klon.setMaxAnzKonstanzqPkw(getMaxAnzKonstanzqPkw());
							klon.setMaxAnzKonstanzvKfz(getMaxAnzKonstanzvKfz());
							klon.setMaxAnzKonstanzvLkw(getMaxAnzKonstanzvLkw());
							klon.setMaxAnzKonstanzvPkw(getMaxAnzKonstanzvPkw());
							klon.setMaxAnzKonstanzStreung(getMaxAnzKonstanzStreung());
							klon.setMaxAnzKonstanzBelegung(getMaxAnzKonstanzBelegung());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenDifferenzialKontrolleFs";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerkehrsDatenDifferenzialKontrolleFs(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
