/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für PL-Prüfung logisch bei Kurzzeitdaten
					Verkehr.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 59
 */
public class PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2 extends AbstractParameterDatensatz<PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _erzeugeBetriebsmeldungPruefungTLS
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _erzeugeBetriebsmeldungPruefungVerkehr
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vKfzGrenz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _bGrenz
				;
				private 	RelativerZeitstempel
				 _pruefintervallAusfallHaeufigkeit
				;
				private 	RelativerZeitstempel
				 _maxAusfallZeitProTag
				;
				private 	RelativerZeitstempel
				 _bezugszeitraumVertrauensbereich
				;
				private 	RelativerZeitstempel
				 _pruefintervallVertrauensbereich
				;
				private 	RelativerZeitstempel
				 _maxAusfallzeitVertrauensbereichEin
				;
				private 	RelativerZeitstempel
				 _maxAusfallzeitVertrauensbereichAus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerhaltenGrenzwertPruefungVerkehr
				 _verhaltenGrenzwertPruefung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _qKfzMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _qLkwMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vKfzMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vLkwMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vPkwMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vgKfzMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _bMax
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Gibt an, ob eine Betriebsmeldung erzeugt wird, wenn die PL-Prüfung FG1 TLS implausible Werte an
									diesem Fahrstreifen feststellt.
			<p>
			
			</p>
			
			@return der Wert von ErzeugeBetriebsmeldungPruefungTLS.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getErzeugeBetriebsmeldungPruefungTLS() {
				return _erzeugeBetriebsmeldungPruefungTLS;
			}
		
			/**
			Gibt an, ob eine Betriebsmeldung erzeugt wird, wenn die PL-Prüfung FG1 TLS implausible Werte an
									diesem Fahrstreifen feststellt.
			<p>
			
			</p>
			
			@param _erzeugeBetriebsmeldungPruefungTLS der neue Wert von ErzeugeBetriebsmeldungPruefungTLS.
			*/
			public void setErzeugeBetriebsmeldungPruefungTLS(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _erzeugeBetriebsmeldungPruefungTLS) {
				this._erzeugeBetriebsmeldungPruefungTLS = _erzeugeBetriebsmeldungPruefungTLS;
			}
		
			/**
			Gibt an, ob eine Betriebsmeldung erzeugt wird, wenn die PL-Prüfung FG1 Verkehr implausible Werte
									an diesem Fahrstreifen feststellt.
			<p>
			
			</p>
			
			@return der Wert von ErzeugeBetriebsmeldungPruefungVerkehr.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getErzeugeBetriebsmeldungPruefungVerkehr() {
				return _erzeugeBetriebsmeldungPruefungVerkehr;
			}
		
			/**
			Gibt an, ob eine Betriebsmeldung erzeugt wird, wenn die PL-Prüfung FG1 Verkehr implausible Werte
									an diesem Fahrstreifen feststellt.
			<p>
			
			</p>
			
			@param _erzeugeBetriebsmeldungPruefungVerkehr der neue Wert von ErzeugeBetriebsmeldungPruefungVerkehr.
			*/
			public void setErzeugeBetriebsmeldungPruefungVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _erzeugeBetriebsmeldungPruefungVerkehr) {
				this._erzeugeBetriebsmeldungPruefungVerkehr = _erzeugeBetriebsmeldungPruefungVerkehr;
			}
		
			/**
			Grenzgeschwindigkeit für PL-Prüfung FG1 Verkehr. Ist dieser
									Wert überschritten, muss b kleiner bGrenz sein,
									sonst ist b implausibel.
			<p>
			
			</p>
			
			@return der Wert von VKfzGrenz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVKfzGrenz() {
				return _vKfzGrenz;
			}
		
			/**
			Grenzgeschwindigkeit für PL-Prüfung FG1 Verkehr. Ist dieser
									Wert überschritten, muss b kleiner bGrenz sein,
									sonst ist b implausibel.
			<p>
			
			</p>
			
			@param _vKfzGrenz der neue Wert von VKfzGrenz.
			*/
			public void setVKfzGrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vKfzGrenz) {
				this._vKfzGrenz = _vKfzGrenz;
			}
		
			/**
			Ist vKfz größer als vKfzGrenz, so muss b kleiner
									bGrenz sein, sonst ist b implausibel.
			<p>
			
			</p>
			
			@return der Wert von BGrenz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getBGrenz() {
				return _bGrenz;
			}
		
			/**
			Ist vKfz größer als vKfzGrenz, so muss b kleiner
									bGrenz sein, sonst ist b implausibel.
			<p>
			
			</p>
			
			@param _bGrenz der neue Wert von BGrenz.
			*/
			public void setBGrenz(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _bGrenz) {
				this._bGrenz = _bGrenz;
			}
		
			/**
			Prüfintervall für die Überwachung der Ausfallhäufigkeit eines Fahrstreifens.
			<p>
			
			</p>
			
			@return der Wert von PruefintervallAusfallHaeufigkeit.
			*/
				public 	RelativerZeitstempel
				 getPruefintervallAusfallHaeufigkeit() {
				return _pruefintervallAusfallHaeufigkeit;
			}
		
			/**
			Prüfintervall für die Überwachung der Ausfallhäufigkeit eines Fahrstreifens.
			<p>
			
			</p>
			
			@param _pruefintervallAusfallHaeufigkeit der neue Wert von PruefintervallAusfallHaeufigkeit.
			*/
			public void setPruefintervallAusfallHaeufigkeit(	RelativerZeitstempel
			 _pruefintervallAusfallHaeufigkeit) {
				this._pruefintervallAusfallHaeufigkeit = _pruefintervallAusfallHaeufigkeit;
			}
		
			/**
			Überschreitet die Ausfallzeit eines Fahrstreifens in den zurückliegenden 24 Stunden die
									angegebene Dauer,
									wird eine Betriebsmeldung abgesetzt. Bei einer Angabe von 0 wird keine Betriebsmeldung
									abgesetzt.
			<p>
			
			</p>
			
			@return der Wert von MaxAusfallZeitProTag.
			*/
				public 	RelativerZeitstempel
				 getMaxAusfallZeitProTag() {
				return _maxAusfallZeitProTag;
			}
		
			/**
			Überschreitet die Ausfallzeit eines Fahrstreifens in den zurückliegenden 24 Stunden die
									angegebene Dauer,
									wird eine Betriebsmeldung abgesetzt. Bei einer Angabe von 0 wird keine Betriebsmeldung
									abgesetzt.
			<p>
			
			</p>
			
			@param _maxAusfallZeitProTag der neue Wert von MaxAusfallZeitProTag.
			*/
			public void setMaxAusfallZeitProTag(	RelativerZeitstempel
			 _maxAusfallZeitProTag) {
				this._maxAusfallZeitProTag = _maxAusfallZeitProTag;
			}
		
			/**
			Zeitraum über den die Ausfalldauer eines Fahrstreifens für die Prüfung des Vertrauensbereichs
									betrachtet wird.
			<p>
			
			</p>
			
			@return der Wert von BezugszeitraumVertrauensbereich.
			*/
				public 	RelativerZeitstempel
				 getBezugszeitraumVertrauensbereich() {
				return _bezugszeitraumVertrauensbereich;
			}
		
			/**
			Zeitraum über den die Ausfalldauer eines Fahrstreifens für die Prüfung des Vertrauensbereichs
									betrachtet wird.
			<p>
			
			</p>
			
			@param _bezugszeitraumVertrauensbereich der neue Wert von BezugszeitraumVertrauensbereich.
			*/
			public void setBezugszeitraumVertrauensbereich(	RelativerZeitstempel
			 _bezugszeitraumVertrauensbereich) {
				this._bezugszeitraumVertrauensbereich = _bezugszeitraumVertrauensbereich;
			}
		
			/**
			Prüfintervall für die Überwachung des Vertrauensbereichs eines Fahrstreifens.
			<p>
			
			</p>
			
			@return der Wert von PruefintervallVertrauensbereich.
			*/
				public 	RelativerZeitstempel
				 getPruefintervallVertrauensbereich() {
				return _pruefintervallVertrauensbereich;
			}
		
			/**
			Prüfintervall für die Überwachung des Vertrauensbereichs eines Fahrstreifens.
			<p>
			
			</p>
			
			@param _pruefintervallVertrauensbereich der neue Wert von PruefintervallVertrauensbereich.
			*/
			public void setPruefintervallVertrauensbereich(	RelativerZeitstempel
			 _pruefintervallVertrauensbereich) {
				this._pruefintervallVertrauensbereich = _pruefintervallVertrauensbereich;
			}
		
			/**
			Überschreitet die Ausfalldauer eines Fahrstreifens im BezugszeitraumVertrauensbereich den hier
									definierten Wert,
									werden zukünftig alle Werte dieses Fahrstreifens als implausibel betrachtet. Dieser Wert sollte
									kleiner-gleich BezugszeitraumVertrauensbereich sein.
			<p>
			
			</p>
			
			@return der Wert von MaxAusfallzeitVertrauensbereichEin.
			*/
				public 	RelativerZeitstempel
				 getMaxAusfallzeitVertrauensbereichEin() {
				return _maxAusfallzeitVertrauensbereichEin;
			}
		
			/**
			Überschreitet die Ausfalldauer eines Fahrstreifens im BezugszeitraumVertrauensbereich den hier
									definierten Wert,
									werden zukünftig alle Werte dieses Fahrstreifens als implausibel betrachtet. Dieser Wert sollte
									kleiner-gleich BezugszeitraumVertrauensbereich sein.
			<p>
			
			</p>
			
			@param _maxAusfallzeitVertrauensbereichEin der neue Wert von MaxAusfallzeitVertrauensbereichEin.
			*/
			public void setMaxAusfallzeitVertrauensbereichEin(	RelativerZeitstempel
			 _maxAusfallzeitVertrauensbereichEin) {
				this._maxAusfallzeitVertrauensbereichEin = _maxAusfallzeitVertrauensbereichEin;
			}
		
			/**
			Unterschreitet die Ausfalldauer eines als implausibel betrachteten Fahrstreifens
									im BezugszeitraumVertrauensbereich den hier definierten Wert, werden zukünftig die
									Fahrstreifenwerte
									wieder normal weiterverwendet. Dieser Wert sollte kleiner-gleich
									MaxAusfallzeitVertrauensbereichEin sein.
			<p>
			
			</p>
			
			@return der Wert von MaxAusfallzeitVertrauensbereichAus.
			*/
				public 	RelativerZeitstempel
				 getMaxAusfallzeitVertrauensbereichAus() {
				return _maxAusfallzeitVertrauensbereichAus;
			}
		
			/**
			Unterschreitet die Ausfalldauer eines als implausibel betrachteten Fahrstreifens
									im BezugszeitraumVertrauensbereich den hier definierten Wert, werden zukünftig die
									Fahrstreifenwerte
									wieder normal weiterverwendet. Dieser Wert sollte kleiner-gleich
									MaxAusfallzeitVertrauensbereichEin sein.
			<p>
			
			</p>
			
			@param _maxAusfallzeitVertrauensbereichAus der neue Wert von MaxAusfallzeitVertrauensbereichAus.
			*/
			public void setMaxAusfallzeitVertrauensbereichAus(	RelativerZeitstempel
			 _maxAusfallzeitVertrauensbereichAus) {
				this._maxAusfallzeitVertrauensbereichAus = _maxAusfallzeitVertrauensbereichAus;
			}
		
			/**
			Definiert das Verhalten der Grenzwertprüfung an diesem Fahrstreifen.
			<p>
			
			</p>
			
			@return der Wert von VerhaltenGrenzwertPruefung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerhaltenGrenzwertPruefungVerkehr
				 getVerhaltenGrenzwertPruefung() {
				return _verhaltenGrenzwertPruefung;
			}
		
			/**
			Definiert das Verhalten der Grenzwertprüfung an diesem Fahrstreifen.
			<p>
			
			</p>
			
			@param _verhaltenGrenzwertPruefung der neue Wert von VerhaltenGrenzwertPruefung.
			*/
			public void setVerhaltenGrenzwertPruefung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerhaltenGrenzwertPruefungVerkehr
			 _verhaltenGrenzwertPruefung) {
				this._verhaltenGrenzwertPruefung = _verhaltenGrenzwertPruefung;
			}
		
			/**
			Wertebereichsgrenzen für qKfz bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@return der Wert von QKfzMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 getQKfzMax() {
				return _qKfzMax;
			}
		
			/**
			Wertebereichsgrenzen für qKfz bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@param _qKfzMax der neue Wert von QKfzMax.
			*/
			public void setQKfzMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _qKfzMax) {
				this._qKfzMax = _qKfzMax;
			}
		
			/**
			Wertebereichsgrenzen für qLkw bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@return der Wert von QLkwMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 getQLkwMax() {
				return _qLkwMax;
			}
		
			/**
			Wertebereichsgrenzen für qLkw bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@param _qLkwMax der neue Wert von QLkwMax.
			*/
			public void setQLkwMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _qLkwMax) {
				this._qLkwMax = _qLkwMax;
			}
		
			/**
			Wertebereichsgrenzen für vKfz bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von VKfzMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVKfzMax() {
				return _vKfzMax;
			}
		
			/**
			Wertebereichsgrenzen für vKfz bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _vKfzMax der neue Wert von VKfzMax.
			*/
			public void setVKfzMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vKfzMax) {
				this._vKfzMax = _vKfzMax;
			}
		
			/**
			Wertebereichsgrenzen für vLkwbei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von VLkwMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVLkwMax() {
				return _vLkwMax;
			}
		
			/**
			Wertebereichsgrenzen für vLkwbei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _vLkwMax der neue Wert von VLkwMax.
			*/
			public void setVLkwMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vLkwMax) {
				this._vLkwMax = _vLkwMax;
			}
		
			/**
			Wertebereichsgrenzen für vPkw bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von VPkwMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVPkwMax() {
				return _vPkwMax;
			}
		
			/**
			Wertebereichsgrenzen für vPkw bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _vPkwMax der neue Wert von VPkwMax.
			*/
			public void setVPkwMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vPkwMax) {
				this._vPkwMax = _vPkwMax;
			}
		
			/**
			Wertebereichsgrenzen für vgKfz bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von VgKfzMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVgKfzMax() {
				return _vgKfzMax;
			}
		
			/**
			Wertebereichsgrenzen für vgKfz bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _vgKfzMax der neue Wert von VgKfzMax.
			*/
			public void setVgKfzMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vgKfzMax) {
				this._vgKfzMax = _vgKfzMax;
			}
		
			/**
			Wertebereichsgrenzen für b (Belegung) bei der
									logischen Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von BMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getBMax() {
				return _bMax;
			}
		
			/**
			Wertebereichsgrenzen für b (Belegung) bei der
									logischen Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _bMax der neue Wert von BMax.
			*/
			public void setBMax(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _bMax) {
				this._bMax = _bMax;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getErzeugeBetriebsmeldungPruefungTLS() != null) {
		                if (getErzeugeBetriebsmeldungPruefungTLS().isZustand()) {
		                    datum.getUnscaledValue("ErzeugeBetriebsmeldungPrüfungTLS").setText(getErzeugeBetriebsmeldungPruefungTLS().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ErzeugeBetriebsmeldungPrüfungTLS").set(getErzeugeBetriebsmeldungPruefungTLS().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getErzeugeBetriebsmeldungPruefungVerkehr() != null) {
		                if (getErzeugeBetriebsmeldungPruefungVerkehr().isZustand()) {
		                    datum.getUnscaledValue("ErzeugeBetriebsmeldungPrüfungVerkehr").setText(getErzeugeBetriebsmeldungPruefungVerkehr().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ErzeugeBetriebsmeldungPrüfungVerkehr").set(getErzeugeBetriebsmeldungPruefungVerkehr().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfzGrenz() != null) {
		                if (getVKfzGrenz().isZustand()) {
		                    datum.getUnscaledValue("vKfzGrenz").setText(getVKfzGrenz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfzGrenz").set(getVKfzGrenz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBGrenz() != null) {
		                if (getBGrenz().isZustand()) {
		                    datum.getUnscaledValue("bGrenz").setText(getBGrenz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("bGrenz").set(getBGrenz().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("PrüfintervallAusfallHäufigkeit").setMillis(getPruefintervallAusfallHaeufigkeit().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("MaxAusfallZeitProTag").setMillis(getMaxAusfallZeitProTag().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("BezugszeitraumVertrauensbereich").setMillis(getBezugszeitraumVertrauensbereich().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("PrüfintervallVertrauensbereich").setMillis(getPruefintervallVertrauensbereich().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("MaxAusfallzeitVertrauensbereichEin").setMillis(getMaxAusfallzeitVertrauensbereichEin().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("MaxAusfallzeitVertrauensbereichAus").setMillis(getMaxAusfallzeitVertrauensbereichAus().getTime());
					// GanzzahlAttributTyp
					if (getVerhaltenGrenzwertPruefung() != null) {
		                if (getVerhaltenGrenzwertPruefung().isZustand()) {
		                    datum.getUnscaledValue("VerhaltenGrenzwertPrüfung").setText(getVerhaltenGrenzwertPruefung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VerhaltenGrenzwertPrüfung").set(getVerhaltenGrenzwertPruefung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKfzMax() != null) {
		                if (getQKfzMax().isZustand()) {
		                    datum.getUnscaledValue("qKfzMax").setText(getQKfzMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKfzMax").set(getQKfzMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwMax() != null) {
		                if (getQLkwMax().isZustand()) {
		                    datum.getUnscaledValue("qLkwMax").setText(getQLkwMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkwMax").set(getQLkwMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfzMax() != null) {
		                if (getVKfzMax().isZustand()) {
		                    datum.getUnscaledValue("vKfzMax").setText(getVKfzMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfzMax").set(getVKfzMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwMax() != null) {
		                if (getVLkwMax().isZustand()) {
		                    datum.getUnscaledValue("vLkwMax").setText(getVLkwMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLkwMax").set(getVLkwMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwMax() != null) {
		                if (getVPkwMax().isZustand()) {
		                    datum.getUnscaledValue("vPkwMax").setText(getVPkwMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vPkwMax").set(getVPkwMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVgKfzMax() != null) {
		                if (getVgKfzMax().isZustand()) {
		                    datum.getUnscaledValue("vgKfzMax").setText(getVgKfzMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vgKfzMax").set(getVgKfzMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBMax() != null) {
		                if (getBMax().isZustand()) {
		                    datum.getUnscaledValue("bMax").setText(getBMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("bMax").set(getBMax().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ErzeugeBetriebsmeldungPrüfungTLS").isState()) {
								setErzeugeBetriebsmeldungPruefungTLS(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("ErzeugeBetriebsmeldungPrüfungTLS").getText()));
							} else {
							setErzeugeBetriebsmeldungPruefungTLS(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("ErzeugeBetriebsmeldungPrüfungTLS").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ErzeugeBetriebsmeldungPrüfungVerkehr").isState()) {
								setErzeugeBetriebsmeldungPruefungVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("ErzeugeBetriebsmeldungPrüfungVerkehr").getText()));
							} else {
							setErzeugeBetriebsmeldungPruefungVerkehr(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("ErzeugeBetriebsmeldungPrüfungVerkehr").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfzGrenz").isState()) {
								setVKfzGrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vKfzGrenz").getText()));
							} else {
							setVKfzGrenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKfzGrenz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("bGrenz").isState()) {
								setBGrenz(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("bGrenz").getText()));
							} else {
							setBGrenz(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("bGrenz").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setPruefintervallAusfallHaeufigkeit(new
							RelativerZeitstempel
							(daten.getTimeValue("PrüfintervallAusfallHäufigkeit").getMillis()));
					// ZeitstempelAttributTyp
						setMaxAusfallZeitProTag(new
							RelativerZeitstempel
							(daten.getTimeValue("MaxAusfallZeitProTag").getMillis()));
					// ZeitstempelAttributTyp
						setBezugszeitraumVertrauensbereich(new
							RelativerZeitstempel
							(daten.getTimeValue("BezugszeitraumVertrauensbereich").getMillis()));
					// ZeitstempelAttributTyp
						setPruefintervallVertrauensbereich(new
							RelativerZeitstempel
							(daten.getTimeValue("PrüfintervallVertrauensbereich").getMillis()));
					// ZeitstempelAttributTyp
						setMaxAusfallzeitVertrauensbereichEin(new
							RelativerZeitstempel
							(daten.getTimeValue("MaxAusfallzeitVertrauensbereichEin").getMillis()));
					// ZeitstempelAttributTyp
						setMaxAusfallzeitVertrauensbereichAus(new
							RelativerZeitstempel
							(daten.getTimeValue("MaxAusfallzeitVertrauensbereichAus").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VerhaltenGrenzwertPrüfung").isState()) {
								setVerhaltenGrenzwertPruefung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerhaltenGrenzwertPruefungVerkehr
								.getZustand(daten.getScaledValue("VerhaltenGrenzwertPrüfung").getText()));
							} else {
							setVerhaltenGrenzwertPruefung(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerhaltenGrenzwertPruefungVerkehr
							(daten.
								getUnscaledValue
							("VerhaltenGrenzwertPrüfung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKfzMax").isState()) {
								setQKfzMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("qKfzMax").getText()));
							} else {
							setQKfzMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("qKfzMax").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkwMax").isState()) {
								setQLkwMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("qLkwMax").getText()));
							} else {
							setQLkwMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("qLkwMax").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfzMax").isState()) {
								setVKfzMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vKfzMax").getText()));
							} else {
							setVKfzMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKfzMax").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLkwMax").isState()) {
								setVLkwMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vLkwMax").getText()));
							} else {
							setVLkwMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLkwMax").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vPkwMax").isState()) {
								setVPkwMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vPkwMax").getText()));
							} else {
							setVPkwMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vPkwMax").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vgKfzMax").isState()) {
								setVgKfzMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vgKfzMax").getText()));
							} else {
							setVgKfzMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vgKfzMax").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("bMax").isState()) {
								setBMax(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("bMax").getText()));
							} else {
							setBMax(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("bMax").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setErzeugeBetriebsmeldungPruefungTLS(getErzeugeBetriebsmeldungPruefungTLS());
							klon.setErzeugeBetriebsmeldungPruefungVerkehr(getErzeugeBetriebsmeldungPruefungVerkehr());
							klon.setVKfzGrenz(getVKfzGrenz());
							klon.setBGrenz(getBGrenz());
							klon.setPruefintervallAusfallHaeufigkeit(getPruefintervallAusfallHaeufigkeit());
							klon.setMaxAusfallZeitProTag(getMaxAusfallZeitProTag());
							klon.setBezugszeitraumVertrauensbereich(getBezugszeitraumVertrauensbereich());
							klon.setPruefintervallVertrauensbereich(getPruefintervallVertrauensbereich());
							klon.setMaxAusfallzeitVertrauensbereichEin(getMaxAusfallzeitVertrauensbereichEin());
							klon.setMaxAusfallzeitVertrauensbereichAus(getMaxAusfallzeitVertrauensbereichAus());
							klon.setVerhaltenGrenzwertPruefung(getVerhaltenGrenzwertPruefung());
							klon.setQKfzMax(getQKfzMax());
							klon.setQLkwMax(getQLkwMax());
							klon.setVKfzMax(getVKfzMax());
							klon.setVLkwMax(getVLkwMax());
							klon.setVPkwMax(getVPkwMax());
							klon.setVgKfzMax(getVgKfzMax());
							klon.setBMax(getBMax());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitIntervallPlausibilitätsPrüfungLogisch2";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
