/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für Verkehrslageverfahren 1 (MARZ).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 59
 */
public class PdVerkehrsLageVerfahren1 extends AbstractParameterDatensatz<PdVerkehrsLageVerfahren1.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _k1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _k2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _k3
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _kT
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Grenzgeschwindigkeit 1 (0&lt;v1&lt;v2).
			<p>
			
			</p>
			
			@return der Wert von V1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV1() {
				return _v1;
			}
		
			/**
			Grenzgeschwindigkeit 1 (0&lt;v1&lt;v2).
			<p>
			
			</p>
			
			@param _v1 der neue Wert von V1.
			*/
			public void setV1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v1) {
				this._v1 = _v1;
			}
		
			/**
			Grenzgeschwindigkeit 2 (0&lt;v1&lt;v2).
			<p>
			
			</p>
			
			@return der Wert von V2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV2() {
				return _v2;
			}
		
			/**
			Grenzgeschwindigkeit 2 (0&lt;v1&lt;v2).
			<p>
			
			</p>
			
			@param _v2 der neue Wert von V2.
			*/
			public void setV2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v2) {
				this._v2 = _v2;
			}
		
			/**
			Grenzfahrzeugdichte 1 (0&lt;k1&lt;k2&lt;K3 UND
									0&lt;kT&lt;k3).
			<p>
			
			</p>
			
			@return der Wert von K1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getK1() {
				return _k1;
			}
		
			/**
			Grenzfahrzeugdichte 1 (0&lt;k1&lt;k2&lt;K3 UND
									0&lt;kT&lt;k3).
			<p>
			
			</p>
			
			@param _k1 der neue Wert von K1.
			*/
			public void setK1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _k1) {
				this._k1 = _k1;
			}
		
			/**
			Grenzfahrzeugdichte 2 (0&lt;k1&lt;k2&lt;K3 UND
									0&lt;kT&lt;k3).
			<p>
			
			</p>
			
			@return der Wert von K2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getK2() {
				return _k2;
			}
		
			/**
			Grenzfahrzeugdichte 2 (0&lt;k1&lt;k2&lt;K3 UND
									0&lt;kT&lt;k3).
			<p>
			
			</p>
			
			@param _k2 der neue Wert von K2.
			*/
			public void setK2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _k2) {
				this._k2 = _k2;
			}
		
			/**
			Grenzfahrzeugdichte 3 (0&lt;k1&lt;k2&lt;K3 UND
									0&lt;kT&lt;k3).
			<p>
			
			</p>
			
			@return der Wert von K3.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getK3() {
				return _k3;
			}
		
			/**
			Grenzfahrzeugdichte 3 (0&lt;k1&lt;k2&lt;K3 UND
									0&lt;kT&lt;k3).
			<p>
			
			</p>
			
			@param _k3 der neue Wert von K3.
			*/
			public void setK3(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _k3) {
				this._k3 = _k3;
			}
		
			/**
			Grenzfahrzeugdichte T (0&lt;k1&lt;k2&lt;K3 UND
									0&lt;kT&lt;k3).
			<p>
			
			</p>
			
			@return der Wert von KT.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getKT() {
				return _kT;
			}
		
			/**
			Grenzfahrzeugdichte T (0&lt;k1&lt;k2&lt;K3 UND
									0&lt;kT&lt;k3).
			<p>
			
			</p>
			
			@param _kT der neue Wert von KT.
			*/
			public void setKT(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _kT) {
				this._kT = _kT;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getV1() != null) {
		                if (getV1().isZustand()) {
		                    datum.getUnscaledValue("v1").setText(getV1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v1").set(getV1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV2() != null) {
		                if (getV2().isZustand()) {
		                    datum.getUnscaledValue("v2").setText(getV2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v2").set(getV2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getK1() != null) {
		                if (getK1().isZustand()) {
		                    datum.getUnscaledValue("k1").setText(getK1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("k1").set(getK1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getK2() != null) {
		                if (getK2().isZustand()) {
		                    datum.getUnscaledValue("k2").setText(getK2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("k2").set(getK2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getK3() != null) {
		                if (getK3().isZustand()) {
		                    datum.getUnscaledValue("k3").setText(getK3().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("k3").set(getK3().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKT() != null) {
		                if (getKT().isZustand()) {
		                    datum.getUnscaledValue("kT").setText(getKT().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("kT").set(getKT().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v1").isState()) {
								setV1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("v1").getText()));
							} else {
							setV1(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("v1").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v2").isState()) {
								setV2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("v2").getText()));
							} else {
							setV2(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("v2").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("k1").isState()) {
								setK1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("k1").getText()));
							} else {
							setK1(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("k1").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("k2").isState()) {
								setK2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("k2").getText()));
							} else {
							setK2(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("k2").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("k3").isState()) {
								setK3(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("k3").getText()));
							} else {
							setK3(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("k3").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("kT").isState()) {
								setKT(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("kT").getText()));
							} else {
							setKT(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("kT").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setV1(getV1());
							klon.setV2(getV2());
							klon.setK1(getK1());
							klon.setK2(getK2());
							klon.setK3(getK3());
							klon.setKT(getKT());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsLageVerfahren1";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerkehrsLageVerfahren1(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
