/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fuzzy-Set (Parameter) für Verkehrszustand im
					Verkehr.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdVerkehrsZustandFuzzy extends AbstractParameterDatensatz<PdVerkehrsZustandFuzzy.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlLinguistischeVariableStandard
				> _verkehrsZustand = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlLinguistischeVariableStandard
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLinguistischeVariableStandard
				 _minimum
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLinguistischeVariableStandard
				 _maximum
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			VerkehrsZustand als lingustische Variable.
			<p>
			
			</p>
			
			@return der Wert von VerkehrsZustand.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlLinguistischeVariableStandard
				> getVerkehrsZustand() {
				return _verkehrsZustand;
			}
		
		
			/**
			Minimum des Wertebereichs (für
									Defuzzifizierung).
			<p>
			
			</p>
			
			@return der Wert von Minimum.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLinguistischeVariableStandard
				 getMinimum() {
				return _minimum;
			}
		
			/**
			Minimum des Wertebereichs (für
									Defuzzifizierung).
			<p>
			
			</p>
			
			@param _minimum der neue Wert von Minimum.
			*/
			public void setMinimum(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLinguistischeVariableStandard
			 _minimum) {
				this._minimum = _minimum;
			}
		
			/**
			Maximum des Wertebereichs (für
									Defuzzifizierung).
			<p>
			
			</p>
			
			@return der Wert von Maximum.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLinguistischeVariableStandard
				 getMaximum() {
				return _maximum;
			}
		
			/**
			Maximum des Wertebereichs (für
									Defuzzifizierung).
			<p>
			
			</p>
			
			@param _maximum der neue Wert von Maximum.
			*/
			public void setMaximum(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLinguistischeVariableStandard
			 _maximum) {
				this._maximum = _maximum;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayVerkehrsZustand = datum.getArray("VerkehrsZustand");
						arrayVerkehrsZustand.setLength(getVerkehrsZustand().size());
						for (int i = 0; i < arrayVerkehrsZustand.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlLinguistischeVariableStandard
							 atl = getVerkehrsZustand().get(i);
							atl.bean2Atl(arrayVerkehrsZustand.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getMinimum() != null) {
		                if (getMinimum().isZustand()) {
		                    datum.getUnscaledValue("Minimum").setText(getMinimum().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Minimum").set(getMinimum().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaximum() != null) {
		                if (getMaximum().isZustand()) {
		                    datum.getUnscaledValue("Maximum").setText(getMaximum().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Maximum").set(getMaximum().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayVerkehrsZustand = daten.getArray("VerkehrsZustand");
						for (int i = 0; i < arrayVerkehrsZustand.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlLinguistischeVariableStandard
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlLinguistischeVariableStandard
							 ();
							atl.atl2Bean(arrayVerkehrsZustand.getItem(i), factory);
							getVerkehrsZustand().add(atl);
						}
					// GanzzahlAttributTyp
							setMinimum(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLinguistischeVariableStandard
							(daten.
								getUnscaledValue
							("Minimum").
									intValue
							()));
					// GanzzahlAttributTyp
							setMaximum(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLinguistischeVariableStandard
							(daten.
								getUnscaledValue
							("Maximum").
									intValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._verkehrsZustand = getVerkehrsZustand().clone();
							klon.setMinimum(getMinimum());
							klon.setMaximum(getMaximum());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsZustandFuzzy";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerkehrsZustandFuzzy(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
