/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Filter.
<p>
Mit dieser Attributliste wird spezifiziert, fuer welche auf dem Informationskanal empfangenen Meldungen die folgende spezifizierte
					Aktion durchgefuehrt werden soll. Die Attributliste ist als Feld ausgelegt und somit koennen mehere Kriterien angegeben werden.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlBetriebsMeldungsVerwaltungFilter implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrKriterium
			 _kriterium
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrOperation
			 _operation
			;
			private Feld<String
			> _wert = new Feld<String
			>(0, true);
	
		/**
		Mit diesem Attribut wird ein zu pruefendes Kriterium angegeben.
		<p>
		
		</p>
		
		@return der Wert von Kriterium.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrKriterium
			 getKriterium() {
			return _kriterium;
		}
	
		/**
		Mit diesem Attribut wird ein zu pruefendes Kriterium angegeben.
		<p>
		
		</p>
		
		@param _kriterium der neue Wert von Kriterium.
		*/
		public void setKriterium(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrKriterium
		 _kriterium) {
			this._kriterium = _kriterium;
		}
	
		/**
		Mit diesem Attribut wird  die Vergleichsoperation angegeben, wie das Kriterium mit den entsprechenden Werten verglichen werden
								soll.
		<p>
		
		</p>
		
		@return der Wert von Operation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrOperation
			 getOperation() {
			return _operation;
		}
	
		/**
		Mit diesem Attribut wird  die Vergleichsoperation angegeben, wie das Kriterium mit den entsprechenden Werten verglichen werden
								soll.
		<p>
		
		</p>
		
		@param _operation der neue Wert von Operation.
		*/
		public void setOperation(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrOperation
		 _operation) {
			this._operation = _operation;
		}
	
		/**
		Mit diesem Attribut wird der erforderliche Wert spezifiziert, den das Kriterium aufweisen muss, damit die entsprechende Aktion
								durchgefuehrt wird. Das Attribut ist als Feld ausgelegt und somit koennen mehere Werte angegeben werden.
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public Feld<String
			> getWert() {
			return _wert;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getKriterium() != null) {
	                if (getKriterium().isZustand()) {
	                    datum.getUnscaledValue("Kriterium").setText(getKriterium().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Kriterium").set(getKriterium().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOperation() != null) {
	                if (getOperation().isZustand()) {
	                    datum.getUnscaledValue("Operation").setText(getOperation().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Operation").set(getOperation().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getWert() != null) {
					final Data.TextArray arrayWert = datum.getTextArray("Wert");
					arrayWert.setLength(getWert().size());
					for (int i = 0; i < arrayWert.getLength(); ++i) {
						arrayWert.getTextValue(i).setText(getWert().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Kriterium").isState()) {
							setKriterium(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrKriterium
							.getZustand(daten.getScaledValue("Kriterium").getText()));
						} else {
						setKriterium(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrKriterium
						(daten.
							getUnscaledValue
						("Kriterium").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Operation").isState()) {
							setOperation(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrOperation
							.getZustand(daten.getScaledValue("Operation").getText()));
						} else {
						setOperation(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrOperation
						(daten.
							getUnscaledValue
						("Operation").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayWert = daten.getTextArray("Wert");
					for (int i = 0; i < arrayWert.getLength(); ++i) {
						getWert().add(arrayWert.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBetriebsMeldungsVerwaltungFilter clone() {
		AtlBetriebsMeldungsVerwaltungFilter klon = new AtlBetriebsMeldungsVerwaltungFilter();
		
						klon.setKriterium(getKriterium());
						klon.setOperation(getOperation());
					klon._wert = getWert().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
