/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Spezifikation für eine Regel.
<p>
Mit Hilfe dieser Attributliste werden die Filter und Aktionen für eine Regel spezifiziert.
					Mit der variablen Attributliste Filter können mehrere Filterkriterien angegeben werden, wobei die einzelnen Kriterien UND-verknüpft werden.
					Die variable Attributliste Aktion legt alle auzuführenden Aktionen fest, die durchgeführt werden, wenn alle Filterkriterien erfüllt sind.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlBetriebsMeldungsVerwaltungRegel implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungFilter
			> _filter = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungFilter
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungAktion
			> _aktion = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungAktion
			>(0, true);
	
		/**
		Filter.
		<p>
		Mit dieser Attributliste wird spezifiziert, fuer welche auf dem Informationskanal empfangenen Meldungen die folgende spezifizierte
							Aktion durchgefuehrt werden soll. Die Attributliste ist als Feld ausgelegt und somit koennen mehere Kriterien angegeben werden.
		</p>
		
		@return der Wert von Filter.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungFilter
			> getFilter() {
			return _filter;
		}
	
	
		/**
		Aktion.
		<p>
		Mit dieser Attributliste wird spezifiziert, welche Aktion durchgefuehrt wird, wenn die Filterbedingung erfuellt ist. Die Attributliste
							ist als Feld ausgelegt und somit koennen mehere Aktionen angegeben werden.
		</p>
		
		@return der Wert von Aktion.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungAktion
			> getAktion() {
			return _aktion;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayFilter = datum.getArray("Filter");
					arrayFilter.setLength(getFilter().size());
					for (int i = 0; i < arrayFilter.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungFilter
						 atl = getFilter().get(i);
						atl.bean2Atl(arrayFilter.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayAktion = datum.getArray("Aktion");
					arrayAktion.setLength(getAktion().size());
					for (int i = 0; i < arrayAktion.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungAktion
						 atl = getAktion().get(i);
						atl.bean2Atl(arrayAktion.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayFilter = daten.getArray("Filter");
					for (int i = 0; i < arrayFilter.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungFilter
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungFilter
						 ();
						atl.atl2Bean(arrayFilter.getItem(i), factory);
						getFilter().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayAktion = daten.getArray("Aktion");
					for (int i = 0; i < arrayAktion.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungAktion
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBetriebsMeldungsVerwaltungAktion
						 ();
						atl.atl2Bean(arrayAktion.getItem(i), factory);
						getAktion().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBetriebsMeldungsVerwaltungRegel clone() {
		AtlBetriebsMeldungsVerwaltungRegel klon = new AtlBetriebsMeldungsVerwaltungRegel();
		
					klon._filter = getFilter().clone();
					klon._aktion = getAktion().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
