/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Urlasserinformationen.
<p>
Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlUrlasser implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "null")
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 _benutzerReferenz
			;
			@Defaultwert(wert = "")
			private String
			 _ursache
			= new String
			()
			;
			@Defaultwert(wert = "")
			private String
			 _veranlasser
			= new String
			()
			;
	
		/**
		Referenz auf den Benutzer, der die Meldung erzeugt hat.
		<p>
		
		</p>
		
		@return der Wert von BenutzerReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 getBenutzerReferenz() {
			return _benutzerReferenz;
		}
	
		/**
		Referenz auf den Benutzer, der die Meldung erzeugt hat.
		<p>
		
		</p>
		
		@param _benutzerReferenz der neue Wert von BenutzerReferenz.
		*/
		public void setBenutzerReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
		 _benutzerReferenz) {
			this._benutzerReferenz = _benutzerReferenz;
		}
	
		/**
		Angabe der Ursache für die Meldung.
		<p>
		
		</p>
		
		@return der Wert von Ursache.
		*/
			public String
			 getUrsache() {
			return _ursache;
		}
	
		/**
		Angabe der Ursache für die Meldung.
		<p>
		
		</p>
		
		@param _ursache der neue Wert von Ursache.
		*/
		public void setUrsache(String
		 _ursache) {
			if (_ursache.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._ursache = _ursache;
		}
	
		/**
		Veranlasser für die Meldung.
		<p>
		
		</p>
		
		@return der Wert von Veranlasser.
		*/
			public String
			 getVeranlasser() {
			return _veranlasser;
		}
	
		/**
		Veranlasser für die Meldung.
		<p>
		
		</p>
		
		@param _veranlasser der neue Wert von Veranlasser.
		*/
		public void setVeranlasser(String
		 _veranlasser) {
			if (_veranlasser.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._veranlasser = _veranlasser;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soBenutzerReferenz = getBenutzerReferenz();
					final SystemObject tmpBenutzerReferenz;
						if (soBenutzerReferenz instanceof SystemObject) {
							tmpBenutzerReferenz = (SystemObject)soBenutzerReferenz;
						} else if(soBenutzerReferenz instanceof SystemObjekt){
							tmpBenutzerReferenz = ((SystemObjekt)soBenutzerReferenz).getSystemObject();
						} else{
							tmpBenutzerReferenz = null;
						}
					datum.getReferenceValue("BenutzerReferenz").setSystemObject(tmpBenutzerReferenz);
				// ZeichenkettenAttributTyp
				if (getUrsache() != null) {
					datum.getTextValue("Ursache").setText(getUrsache());
				}
				// ZeichenkettenAttributTyp
				if (getVeranlasser() != null) {
					datum.getTextValue("Veranlasser").setText(getVeranlasser());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idBenutzerReferenz = daten.getReferenceValue("BenutzerReferenz").getId();
					final SystemObjekt tmpBenutzerReferenz;
					if (idBenutzerReferenz == 0) {
						tmpBenutzerReferenz = null;
					} else {
						final SystemObject soBenutzerReferenz = factory.getDav().getDataModel().getObject(idBenutzerReferenz);
						if (soBenutzerReferenz == null) {
								tmpBenutzerReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.BenutzerUngueltig(idBenutzerReferenz);
						} else {
							tmpBenutzerReferenz = factory.getModellobjekt(soBenutzerReferenz);
						}
					}
					setBenutzerReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
					) tmpBenutzerReferenz);
				// ZeichenkettenAttributTyp
					setUrsache(daten.getTextValue("Ursache").getText());
				// ZeichenkettenAttributTyp
					setVeranlasser(daten.getTextValue("Veranlasser").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUrlasser clone() {
		AtlUrlasser klon = new AtlUrlasser();
		
						klon.setBenutzerReferenz(getBenutzerReferenz());
						klon.setUrsache(getUrsache());
						klon.setVeranlasser(getVeranlasser());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
