/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Status der Meldung.
<p>
Für eine Meldung gibt es fünf verschiedene Stati: "Gutmeldung", "Meldung", "Neue Meldung", "Wiederholungsmeldung" und "Änderungsmeldung".
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttMeldungsStatus extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Meldung, die nicht mit einem der anderen Status bezeichnet werden kann.
	<p>
	Diese Meldung wird von Applikationen benutzt, die den für die Unterscheidung der drei Fälle "Neue Meldung",
								"Wiederholungsmeldung" und "Änderungsmeldung" notwendigen Verwaltungsaufwand nicht selbst vornehmen können oder möchten.
	</p>
	*/
	public static final AttMeldungsStatus ZUSTAND_0_MELDUNG = new AttMeldungsStatus("Meldung", 		Byte
	.valueOf("0"));

	/**
	Meldung, die zu einer zuvor gesandten Meldung gehört und deren Inhalt wieder aufhebt.
	<p>
	
	</p>
	*/
	public static final AttMeldungsStatus ZUSTAND_1_GUTMELDUNG = new AttMeldungsStatus("Gutmeldung", 		Byte
	.valueOf("1"));

	/**
	Eine Meldung, die zum ersten Mal rausgeschickt wird.
	<p>
	
	</p>
	*/
	public static final AttMeldungsStatus ZUSTAND_2_NEUE_MELDUNG = new AttMeldungsStatus("Neue Meldung", 		Byte
	.valueOf("2"));

	/**
	Eine Meldung, die zu einer bereits zuvor gesendeten Meldung gehört.
	<p>
	
	</p>
	*/
	public static final AttMeldungsStatus ZUSTAND_3_WIEDERHOLUNGSMELDUNG = new AttMeldungsStatus("Wiederholungsmeldung", 		Byte
	.valueOf("3"));

	/**
	Meldung, die zu einer zuvor gesendeten Meldung gehört und deren Inhalt modifiziert.
	<p>
	
	</p>
	*/
	public static final AttMeldungsStatus ZUSTAND_4_AENDERUNGSMELDUNG = new AttMeldungsStatus("Änderungsmeldung", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttMeldungsStatus getZustand(final 		Byte
	 value) {
		for (AttMeldungsStatus e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttMeldungsStatus getZustand(final String value) {
		for (AttMeldungsStatus e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttMeldungsStatus> getZustaende() {
		List<AttMeldungsStatus> list = new ArrayList<AttMeldungsStatus>();
		list.add(ZUSTAND_0_MELDUNG);
		list.add(ZUSTAND_1_GUTMELDUNG);
		list.add(ZUSTAND_2_NEUE_MELDUNG);
		list.add(ZUSTAND_3_WIEDERHOLUNGSMELDUNG);
		list.add(ZUSTAND_4_AENDERUNGSMELDUNG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Status.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttMeldungsStatus(final 		Byte
	 value) {
		super(value);
	}
	
	private AttMeldungsStatus(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
