/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition eines Kriteriums für den Filter.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AttVewBetrKriterium extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_0_MELDUNGSTYP = new AttVewBetrKriterium("Meldungstyp", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_1_MELDUNGSKLASSE = new AttVewBetrKriterium("Meldungsklasse", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_2_APPLIKATION = new AttVewBetrKriterium("Applikation", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_3_REFERENZ = new AttVewBetrKriterium("Referenz", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_4_BENUTZER = new AttVewBetrKriterium("Benutzer", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_5_VERANLASSER = new AttVewBetrKriterium("Veranlasser", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_6_URSACHE = new AttVewBetrKriterium("Ursache", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_7_ERWEITERT = new AttVewBetrKriterium("erweitert", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrKriterium ZUSTAND_8_MELDUNGSTEXT = new AttVewBetrKriterium("Meldungstext", 		Byte
	.valueOf("8"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttVewBetrKriterium getZustand(final 		Byte
	 value) {
		for (AttVewBetrKriterium e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttVewBetrKriterium getZustand(final String value) {
		for (AttVewBetrKriterium e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttVewBetrKriterium> getZustaende() {
		List<AttVewBetrKriterium> list = new ArrayList<AttVewBetrKriterium>();
		list.add(ZUSTAND_0_MELDUNGSTYP);
		list.add(ZUSTAND_1_MELDUNGSKLASSE);
		list.add(ZUSTAND_2_APPLIKATION);
		list.add(ZUSTAND_3_REFERENZ);
		list.add(ZUSTAND_4_BENUTZER);
		list.add(ZUSTAND_5_VERANLASSER);
		list.add(ZUSTAND_6_URSACHE);
		list.add(ZUSTAND_7_ERWEITERT);
		list.add(ZUSTAND_8_MELDUNGSTEXT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut VewBetrKriterium.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttVewBetrKriterium(final 		Byte
	 value) {
		super(value);
	}
	
	private AttVewBetrKriterium(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
