/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beinhaltet alle Merkmale, die eine Betriebsmeldung ausmachen.
<p>
&lt;absatz&gt;Fast alle Funktionen des Systems setzen in bestimmten Situationen (i.d.R. beim Auftreten von Fehlern und sonstigen Ausnahmefällen), die ein Eingreifen durch den Operator nötig machen, zusätzlich zur normalen Protokollierung des entsprechenden Ereignisses eine (quittierungspflichtige) Meldung an das Bedienpersonal ab. Diese Meldungen werden zusätzlich in einem einheitlichen Format generiert und zentral verwaltet. Die Quittierung und Manipulation (Ergänzung um Kommentare etc.) dieser (Fehler-)Meldungen erfolgt ausschließlich auf Basis dieser zusätzlich erzeugten Meldungen.&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class OdBetriebsMeldung extends AbstractOnlineDatensatz<OdBetriebsMeldung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Information,
				};
			}
	
			/**
			 * Aspekt zum Senden von Betriebsmeldungen.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Information = new Aspekte("Information", "asp.information");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _applikationsID
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _laufendeNummer
				;
				private 	Object
				 _applikationsTyp
				;
				private String
				 _applikationsKennung
				= new String
				()
				;
				private String
				 _iD
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
				 _meldungsTyp
				;
				private String
				 _meldungsTypZusatz
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
				 _meldungsKlasse
				;
				private Feld<	Object
				> _referenz = new Feld<	Object
				>(1, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
				 _status
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _meldungsText
				= new String
				()
				;
		
			/**
			ID der Applikation, die die Informationsmeldung erzeugt hat.
			<p>
			ID der Applikation, die die Informationsmeldung erzeugt hat. Die ApplikationsID wird bei jedem Start einer Applikation eindeutig vergeben. Damit lässt sich im Nachhinein verfolgen, welche Applikation die Meldung veranlasst hat.
			</p>
			
			@return der Wert von ApplikationsID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getApplikationsID() {
				return _applikationsID;
			}
		
			/**
			ID der Applikation, die die Informationsmeldung erzeugt hat.
			<p>
			ID der Applikation, die die Informationsmeldung erzeugt hat. Die ApplikationsID wird bei jedem Start einer Applikation eindeutig vergeben. Damit lässt sich im Nachhinein verfolgen, welche Applikation die Meldung veranlasst hat.
			</p>
			
			@param _applikationsID der neue Wert von ApplikationsID.
			*/
			public void setApplikationsID(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _applikationsID) {
				this._applikationsID = _applikationsID;
			}
		
			/**
			Laufende Nummerierung der durch die Applikation seit dem Applikationsstart erzeugten Informationsmeldungen.
			<p>
			Laufende Nummerierung der durch die Applikation seit dem Applikationsstart erzeugten Informationsmeldungen. Aus der Kombination von ApplikationsID und LaufendeNummer lässt sich prüfen, ob Meldungen verloren wurden.
			</p>
			
			@return der Wert von LaufendeNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getLaufendeNummer() {
				return _laufendeNummer;
			}
		
			/**
			Laufende Nummerierung der durch die Applikation seit dem Applikationsstart erzeugten Informationsmeldungen.
			<p>
			Laufende Nummerierung der durch die Applikation seit dem Applikationsstart erzeugten Informationsmeldungen. Aus der Kombination von ApplikationsID und LaufendeNummer lässt sich prüfen, ob Meldungen verloren wurden.
			</p>
			
			@param _laufendeNummer der neue Wert von LaufendeNummer.
			*/
			public void setLaufendeNummer(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _laufendeNummer) {
				this._laufendeNummer = _laufendeNummer;
			}
		
			/**
			Typ der Applikation, die die Informationsmeldung erzeugt hat.
			<p>
			
			</p>
			
			@return der Wert von ApplikationsTyp.
			*/
				public 	Object
				 getApplikationsTyp() {
				return _applikationsTyp;
			}
		
			/**
			Typ der Applikation, die die Informationsmeldung erzeugt hat.
			<p>
			
			</p>
			
			@param _applikationsTyp der neue Wert von ApplikationsTyp.
			*/
			public void setApplikationsTyp(	Object
			 _applikationsTyp) {
				this._applikationsTyp = _applikationsTyp;
			}
		
			/**
			Wird für einen Bezug zur vorherigen Meldung benötigt.
			<p>
			Die ApplikationsKennung wird benötigt, um einen Bezug zur vorherigen Meldung herzustellen. Sie wird einmal im Code der Applikation festgelegt und ist für diese Applikation immer gleich.
			</p>
			
			@return der Wert von ApplikationsKennung.
			*/
				public String
				 getApplikationsKennung() {
				return _applikationsKennung;
			}
		
			/**
			Wird für einen Bezug zur vorherigen Meldung benötigt.
			<p>
			Die ApplikationsKennung wird benötigt, um einen Bezug zur vorherigen Meldung herzustellen. Sie wird einmal im Code der Applikation festgelegt und ist für diese Applikation immer gleich.
			</p>
			
			@param _applikationsKennung der neue Wert von ApplikationsKennung.
			*/
			public void setApplikationsKennung(String
			 _applikationsKennung) {
				if (_applikationsKennung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._applikationsKennung = _applikationsKennung;
			}
		
			/**
			ID der Meldung.
			<p>
			ID der Meldung. Dieses Attribut kann bei jeder Meldung von der Applikation gesetzt werden, um einen Bezug zu einer vorherigen Meldung herzustellen.
			</p>
			
			@return der Wert von ID.
			*/
				public String
				 getID() {
				return _iD;
			}
		
			/**
			ID der Meldung.
			<p>
			ID der Meldung. Dieses Attribut kann bei jeder Meldung von der Applikation gesetzt werden, um einen Bezug zu einer vorherigen Meldung herzustellen.
			</p>
			
			@param _iD der neue Wert von ID.
			*/
			public void setID(String
			 _iD) {
				if (_iD.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._iD = _iD;
			}
		
			/**
			Klassifizierung der Meldungen in unterschiedliche Typen.
			<p>
			Klassifizierung der Meldungen in unterschiedliche Typen, die eine inhaltliche Unterscheidung der Meldungen bewirken. Z.B. System und Fach für Meldungen, die sich auf programmtechnische oder fachliche Zustände beziehen.
			</p>
			
			@return der Wert von MeldungsTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
				 getMeldungsTyp() {
				return _meldungsTyp;
			}
		
			/**
			Klassifizierung der Meldungen in unterschiedliche Typen.
			<p>
			Klassifizierung der Meldungen in unterschiedliche Typen, die eine inhaltliche Unterscheidung der Meldungen bewirken. Z.B. System und Fach für Meldungen, die sich auf programmtechnische oder fachliche Zustände beziehen.
			</p>
			
			@param _meldungsTyp der neue Wert von MeldungsTyp.
			*/
			public void setMeldungsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
			 _meldungsTyp) {
				this._meldungsTyp = _meldungsTyp;
			}
		
			/**
			Zur genaueren Beschreibung des MeldungsTyps.
			<p>
			Der MeldungsTypZusatz ermöglicht eine genauere Beschreibung des MeldungsTyps und eine weitere Unterteilung der verschiedenen Typen.
			</p>
			
			@return der Wert von MeldungsTypZusatz.
			*/
				public String
				 getMeldungsTypZusatz() {
				return _meldungsTypZusatz;
			}
		
			/**
			Zur genaueren Beschreibung des MeldungsTyps.
			<p>
			Der MeldungsTypZusatz ermöglicht eine genauere Beschreibung des MeldungsTyps und eine weitere Unterteilung der verschiedenen Typen.
			</p>
			
			@param _meldungsTypZusatz der neue Wert von MeldungsTypZusatz.
			*/
			public void setMeldungsTypZusatz(String
			 _meldungsTypZusatz) {
				if (_meldungsTypZusatz.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._meldungsTypZusatz = _meldungsTypZusatz;
			}
		
			/**
			Klassifizierung einer Meldung.
			<p>
			Hiermit ist die Klassifizierung einer Meldung in "Fatal", "Fehler", "Warnung" und "Information" möglich.
			</p>
			
			@return der Wert von MeldungsKlasse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
				 getMeldungsKlasse() {
				return _meldungsKlasse;
			}
		
			/**
			Klassifizierung einer Meldung.
			<p>
			Hiermit ist die Klassifizierung einer Meldung in "Fatal", "Fehler", "Warnung" und "Information" möglich.
			</p>
			
			@param _meldungsKlasse der neue Wert von MeldungsKlasse.
			*/
			public void setMeldungsKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 _meldungsKlasse) {
				this._meldungsKlasse = _meldungsKlasse;
			}
		
			/**
			Referenz auf ein beliebiges Konfigurationsobjekt.
			<p>
			Referenz auf ein beliebiges Konfigurationsobjekt, auf das sich die Meldung bezieht. Dieses Attribut ist optional.
			</p>
			
			@return der Wert von Referenz.
			*/
				public Feld<	Object
				> getReferenz() {
				return _referenz;
			}
		
		
			/**
			Gibt den Meldungsstatus an.
			<p>
			
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
				 getStatus() {
				return _status;
			}
		
			/**
			Gibt den Meldungsstatus an.
			<p>
			
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
			 _status) {
				this._status = _status;
			}
		
			/**
			Urlasserinformation.
			<p>
			Dieses Attribut wird insbesondere für von Benutzern angelegte Informationsmeldungen benötigt.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformation.
			<p>
			Dieses Attribut wird insbesondere für von Benutzern angelegte Informationsmeldungen benötigt.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Text der Meldung.
			<p>
			
			</p>
			
			@return der Wert von MeldungsText.
			*/
				public String
				 getMeldungsText() {
				return _meldungsText;
			}
		
			/**
			Text der Meldung.
			<p>
			
			</p>
			
			@param _meldungsText der neue Wert von MeldungsText.
			*/
			public void setMeldungsText(String
			 _meldungsText) {
				if (_meldungsText.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._meldungsText = _meldungsText;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getApplikationsID() != null) {
		                if (getApplikationsID().isZustand()) {
		                    datum.getUnscaledValue("ApplikationsID").setText(getApplikationsID().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ApplikationsID").set(getApplikationsID().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaufendeNummer() != null) {
		                if (getLaufendeNummer().isZustand()) {
		                    datum.getUnscaledValue("LaufendeNummer").setText(getLaufendeNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LaufendeNummer").set(getLaufendeNummer().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soApplikationsTyp = getApplikationsTyp();
						final SystemObject tmpApplikationsTyp;
							if (soApplikationsTyp instanceof SystemObject) {
								tmpApplikationsTyp = (SystemObject)soApplikationsTyp;
							} else if(soApplikationsTyp instanceof SystemObjekt){
								tmpApplikationsTyp = ((SystemObjekt)soApplikationsTyp).getSystemObject();
							} else{
								tmpApplikationsTyp = null;
							}
						datum.getReferenceValue("ApplikationsTyp").setSystemObject(tmpApplikationsTyp);
					// ZeichenkettenAttributTyp
					if (getApplikationsKennung() != null) {
						datum.getTextValue("ApplikationsKennung").setText(getApplikationsKennung());
					}
					// ZeichenkettenAttributTyp
					if (getID() != null) {
						datum.getTextValue("ID").setText(getID());
					}
					// GanzzahlAttributTyp
					if (getMeldungsTyp() != null) {
		                if (getMeldungsTyp().isZustand()) {
		                    datum.getUnscaledValue("MeldungsTyp").setText(getMeldungsTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MeldungsTyp").set(getMeldungsTyp().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getMeldungsTypZusatz() != null) {
						datum.getTextValue("MeldungsTypZusatz").setText(getMeldungsTypZusatz());
					}
					// GanzzahlAttributTyp
					if (getMeldungsKlasse() != null) {
		                if (getMeldungsKlasse().isZustand()) {
		                    datum.getUnscaledValue("MeldungsKlasse").setText(getMeldungsKlasse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MeldungsKlasse").set(getMeldungsKlasse().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayReferenz = datum.getReferenceArray("Referenz");
						arrayReferenz.setLength(getReferenz().size());
						for (int i = 0; i < arrayReferenz.getLength(); ++i) {
							final Object soReferenz = getReferenz().get(i);
							final SystemObject tmpReferenz;
							if (soReferenz instanceof SystemObject) {
								tmpReferenz = (SystemObject)soReferenz;
							} else if(soReferenz instanceof SystemObjekt){
								tmpReferenz = ((SystemObjekt)soReferenz).getSystemObject();
							} else{
								tmpReferenz = null;
							}
							arrayReferenz.getReferenceValue(i).setSystemObject(tmpReferenz);
						}
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("Status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Status").set(getStatus().getValue());
		                }
					}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getMeldungsText() != null) {
						datum.getTextValue("MeldungsText").setText(getMeldungsText());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setApplikationsID(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("ApplikationsID").
									longValue
							()));
					// GanzzahlAttributTyp
							setLaufendeNummer(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("LaufendeNummer").
									longValue
							()));
					// ObjektReferenzAttributTyp
						final long idApplikationsTyp = daten.getReferenceValue("ApplikationsTyp").getId();
						final SystemObjekt tmpApplikationsTyp;
						if (idApplikationsTyp == 0) {
							tmpApplikationsTyp = null;
						} else {
							final SystemObject soApplikationsTyp = factory.getDav().getDataModel().getObject(idApplikationsTyp);
							if (soApplikationsTyp == null) {
									tmpApplikationsTyp = new BaseUngueltigesSystemObjekt(idApplikationsTyp);
							} else {
								tmpApplikationsTyp = factory.getModellobjekt(soApplikationsTyp);
							}
						}
						setApplikationsTyp((	Object
						) tmpApplikationsTyp);
					// ZeichenkettenAttributTyp
						setApplikationsKennung(daten.getTextValue("ApplikationsKennung").getText());
					// ZeichenkettenAttributTyp
						setID(daten.getTextValue("ID").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MeldungsTyp").isState()) {
								setMeldungsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
								.getZustand(daten.getScaledValue("MeldungsTyp").getText()));
							} else {
							setMeldungsTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
							(daten.
								getUnscaledValue
							("MeldungsTyp").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setMeldungsTypZusatz(daten.getTextValue("MeldungsTypZusatz").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MeldungsKlasse").isState()) {
								setMeldungsKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
								.getZustand(daten.getScaledValue("MeldungsKlasse").getText()));
							} else {
							setMeldungsKlasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
							(daten.
								getUnscaledValue
							("MeldungsKlasse").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayReferenz = daten.getReferenceArray("Referenz");
						for (int i = 0; i < arrayReferenz.getLength(); ++i) {
							final long idReferenz = daten.getReferenceArray("Referenz").getReferenceValue(i).getId();
							final SystemObjekt tmpReferenz;
							if (idReferenz == 0) {
								tmpReferenz = null;
							} else {
								final SystemObject soReferenz = factory.getDav().getDataModel().getObject(idReferenz);
								if (soReferenz == null) {
										tmpReferenz = new BaseUngueltigesSystemObjekt(idReferenz);
								} else {
									tmpReferenz = factory.getModellobjekt(soReferenz);
								}
							}
								getReferenz().add((	Object
								) tmpReferenz);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Status").isState()) {
								setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
								.getZustand(daten.getScaledValue("Status").getText()));
							} else {
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
							(daten.
								getUnscaledValue
							("Status").
									byteValue
							()));
							}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setMeldungsText(daten.getTextValue("MeldungsText").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setApplikationsID(getApplikationsID());
							klon.setLaufendeNummer(getLaufendeNummer());
							klon.setApplikationsTyp(getApplikationsTyp());
							klon.setApplikationsKennung(getApplikationsKennung());
							klon.setID(getID());
							klon.setMeldungsTyp(getMeldungsTyp());
							klon.setMeldungsTypZusatz(getMeldungsTypZusatz());
							klon.setMeldungsKlasse(getMeldungsKlasse());
						klon._referenz = getReferenz().clone();
							klon.setStatus(getStatus());
							klon._urlasser = getUrlasser().clone();
							klon.setMeldungsText(getMeldungsText());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.betriebsMeldung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBetriebsMeldung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
