/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametrierbare Eigenschaften einer Melddung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdMeldungsBearbeitung extends AbstractOnlineDatensatz<OdMeldungsBearbeitung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Vorgabe,
				};
			}
	
			/**
			 * Vorgabe für eine Zustandsänderung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Vorgabe = new Aspekte("Vorgabe", "asp.vorgabe");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.Meldung
				> _meldungReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.Meldung
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
				 _wichtigkeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
				 _status
				;
				private 	Zeitstempel
				 _wiedervorlage
				;
				private String
				 _benutzerMeldungsAnteil
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Referenzen auf Meldungen.
			<p>
			
			</p>
			
			@return der Wert von MeldungReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.Meldung
				> getMeldungReferenz() {
				return _meldungReferenz;
			}
		
		
			/**
			Dringlichkeit einer Meldung.
			<p>
			&lt;absatz&gt;
										hiermit ist eine Unterscheidung nach der Dringlichkeit der Meldung möglich.
										Ein Wert zwischen 10(sehr Dringend) und 0 (keine Dringlichkeit) ist möglich
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Wichtigkeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
				 getWichtigkeit() {
				return _wichtigkeit;
			}
		
			/**
			Dringlichkeit einer Meldung.
			<p>
			&lt;absatz&gt;
										hiermit ist eine Unterscheidung nach der Dringlichkeit der Meldung möglich.
										Ein Wert zwischen 10(sehr Dringend) und 0 (keine Dringlichkeit) ist möglich
									&lt;&#47;absatz&gt;
			</p>
			
			@param _wichtigkeit der neue Wert von Wichtigkeit.
			*/
			public void setWichtigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
			 _wichtigkeit) {
				this._wichtigkeit = _wichtigkeit;
			}
		
			/**
			Status der Meldung.
			<p>
			&lt;absatz&gt;
										"neu", "in Bearbeitung", "Wiedervorlage", "erledigt
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
				 getStatus() {
				return _status;
			}
		
			/**
			Status der Meldung.
			<p>
			&lt;absatz&gt;
										"neu", "in Bearbeitung", "Wiedervorlage", "erledigt
									&lt;&#47;absatz&gt;
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
			 _status) {
				this._status = _status;
			}
		
			/**
			Zeitpunkt an dem die Meldung erneut vorgelegt (verschickt) werden soll.
			<p>
			
			</p>
			
			@return der Wert von Wiedervorlage.
			*/
				public 	Zeitstempel
				 getWiedervorlage() {
				return _wiedervorlage;
			}
		
			/**
			Zeitpunkt an dem die Meldung erneut vorgelegt (verschickt) werden soll.
			<p>
			
			</p>
			
			@param _wiedervorlage der neue Wert von Wiedervorlage.
			*/
			public void setWiedervorlage(	Zeitstempel
			 _wiedervorlage) {
				this._wiedervorlage = _wiedervorlage;
			}
		
			/**
			Ergänzender Text zur Meldung.
			<p>
			
			</p>
			
			@return der Wert von BenutzerMeldungsAnteil.
			*/
				public String
				 getBenutzerMeldungsAnteil() {
				return _benutzerMeldungsAnteil;
			}
		
			/**
			Ergänzender Text zur Meldung.
			<p>
			
			</p>
			
			@param _benutzerMeldungsAnteil der neue Wert von BenutzerMeldungsAnteil.
			*/
			public void setBenutzerMeldungsAnteil(String
			 _benutzerMeldungsAnteil) {
				if (_benutzerMeldungsAnteil.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._benutzerMeldungsAnteil = _benutzerMeldungsAnteil;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayMeldungReferenz = datum.getReferenceArray("MeldungReferenz");
						arrayMeldungReferenz.setLength(getMeldungReferenz().size());
						for (int i = 0; i < arrayMeldungReferenz.getLength(); ++i) {
							final Object soMeldungReferenz = getMeldungReferenz().get(i);
							final SystemObject tmpMeldungReferenz;
							if (soMeldungReferenz instanceof SystemObject) {
								tmpMeldungReferenz = (SystemObject)soMeldungReferenz;
							} else if(soMeldungReferenz instanceof SystemObjekt){
								tmpMeldungReferenz = ((SystemObjekt)soMeldungReferenz).getSystemObject();
							} else{
								tmpMeldungReferenz = null;
							}
							arrayMeldungReferenz.getReferenceValue(i).setSystemObject(tmpMeldungReferenz);
						}
					// GanzzahlAttributTyp
					if (getWichtigkeit() != null) {
		                if (getWichtigkeit().isZustand()) {
		                    datum.getUnscaledValue("Wichtigkeit").setText(getWichtigkeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Wichtigkeit").set(getWichtigkeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("Status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Status").set(getStatus().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Wiedervorlage").setMillis(getWiedervorlage().getTime());
					// ZeichenkettenAttributTyp
					if (getBenutzerMeldungsAnteil() != null) {
						datum.getTextValue("BenutzerMeldungsAnteil").setText(getBenutzerMeldungsAnteil());
					}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayMeldungReferenz = daten.getReferenceArray("MeldungReferenz");
						for (int i = 0; i < arrayMeldungReferenz.getLength(); ++i) {
							final long idMeldungReferenz = daten.getReferenceArray("MeldungReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpMeldungReferenz;
							if (idMeldungReferenz == 0) {
								tmpMeldungReferenz = null;
							} else {
								final SystemObject soMeldungReferenz = factory.getDav().getDataModel().getObject(idMeldungReferenz);
								if (soMeldungReferenz == null) {
										tmpMeldungReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.impl.MeldungUngueltig(idMeldungReferenz);
								} else {
									tmpMeldungReferenz = factory.getModellobjekt(soMeldungReferenz);
								}
							}
								getMeldungReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.Meldung
								) tmpMeldungReferenz);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Wichtigkeit").isState()) {
								setWichtigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
								.getZustand(daten.getScaledValue("Wichtigkeit").getText()));
							} else {
							setWichtigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
							(daten.
								getUnscaledValue
							("Wichtigkeit").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Status").isState()) {
								setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
								.getZustand(daten.getScaledValue("Status").getText()));
							} else {
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
							(daten.
								getUnscaledValue
							("Status").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setWiedervorlage(new
							Zeitstempel
							(daten.getTimeValue("Wiedervorlage").getMillis()));
					// ZeichenkettenAttributTyp
						setBenutzerMeldungsAnteil(daten.getTextValue("BenutzerMeldungsAnteil").getText());
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._meldungReferenz = getMeldungReferenz().clone();
							klon.setWichtigkeit(getWichtigkeit());
							klon.setStatus(getStatus());
							klon.setWiedervorlage(getWiedervorlage());
							klon.setBenutzerMeldungsAnteil(getBenutzerMeldungsAnteil());
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.meldungsBearbeitung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdMeldungsBearbeitung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
