/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Detailinformationen ueber das Skript.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSkriptDetailinformation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _version
			;
			private String
			 _dateiname
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> _pruefsumme = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			>(0, true);
	
		/**
		Version des Skripts.
		<p>
		
		</p>
		
		@return der Wert von Version.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getVersion() {
			return _version;
		}
	
		/**
		Version des Skripts.
		<p>
		
		</p>
		
		@param _version der neue Wert von Version.
		*/
		public void setVersion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _version) {
			this._version = _version;
		}
	
		/**
		Dateiname des Skripts.
		<p>
		
		</p>
		
		@return der Wert von Dateiname.
		*/
			public String
			 getDateiname() {
			return _dateiname;
		}
	
		/**
		Dateiname des Skripts.
		<p>
		
		</p>
		
		@param _dateiname der neue Wert von Dateiname.
		*/
		public void setDateiname(String
		 _dateiname) {
			if (_dateiname.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._dateiname = _dateiname;
		}
	
		/**
		Pruefsumme des Skripts.
		<p>
		
		</p>
		
		@return der Wert von Pruefsumme.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> getPruefsumme() {
			return _pruefsumme;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVersion() != null) {
	                if (getVersion().isZustand()) {
	                    datum.getUnscaledValue("Version").setText(getVersion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Version").set(getVersion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getDateiname() != null) {
					datum.getTextValue("Dateiname").setText(getDateiname());
				}
				// GanzzahlAttributTyp
				if (getPruefsumme() != null) {
					final Data.NumberArray arrayPruefsumme = datum.
						getUnscaledArray
						("Pruefsumme");
					arrayPruefsumme.setLength(getPruefsumme().size());
					for (int i = 0; i < arrayPruefsumme.getLength(); ++i) {
						arrayPruefsumme.getValue(i).set(getPruefsumme().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setVersion(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Version").
								longValue
						()));
				// ZeichenkettenAttributTyp
					setDateiname(daten.getTextValue("Dateiname").getText());
				// GanzzahlAttributTyp
					final Data.NumberArray arrayPruefsumme = daten.
						getUnscaledArray
					("Pruefsumme");
	
					for (int i = 0; i < arrayPruefsumme.getLength(); ++i) {
	                    getPruefsumme().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
	                    (arrayPruefsumme.
	                    		byteValue
	                    (i)));
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSkriptDetailinformation clone() {
		AtlSkriptDetailinformation klon = new AtlSkriptDetailinformation();
		
						klon.setVersion(getVersion());
						klon.setDateiname(getDateiname());
					klon._pruefsumme = getPruefsumme().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
