/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Nachrichten bei der Abwicklung von
					PUA-Anfragen dient.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AttPuaSkriptOperationsCode extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Erstellen &#47; Editieren eines Skriptes.
	<p>
	
	</p>
	*/
	public static final AttPuaSkriptOperationsCode ZUSTAND_1_ANLEGEN = new AttPuaSkriptOperationsCode("Anlegen", 		Short
	.valueOf("1"));

	/**
	Quelltext eines Skriptes abrufen.
	<p>
	
	</p>
	*/
	public static final AttPuaSkriptOperationsCode ZUSTAND_2_QUELLTEXT = new AttPuaSkriptOperationsCode("Quelltext", 		Short
	.valueOf("2"));

	/**
	Standard-Werte eines Skriptes abrufen.
	<p>
	
	</p>
	*/
	public static final AttPuaSkriptOperationsCode ZUSTAND_3_STANDARD_WERTE = new AttPuaSkriptOperationsCode("Standard-Werte", 		Short
	.valueOf("3"));

	/**
	Zeigt an, das eine Fehlermeldung uebertragen wird.
	<p>
	
	</p>
	*/
	public static final AttPuaSkriptOperationsCode ZUSTAND_100_FEHLER = new AttPuaSkriptOperationsCode("Fehler", 		Short
	.valueOf("100"));

	/**
	Eine positive Quittungsmeldung.
	<p>
	
	</p>
	*/
	public static final AttPuaSkriptOperationsCode ZUSTAND_200_QUITTUNG = new AttPuaSkriptOperationsCode("Quittung", 		Short
	.valueOf("200"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttPuaSkriptOperationsCode getZustand(final 		Short
	 value) {
		for (AttPuaSkriptOperationsCode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttPuaSkriptOperationsCode getZustand(final String value) {
		for (AttPuaSkriptOperationsCode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttPuaSkriptOperationsCode> getZustaende() {
		List<AttPuaSkriptOperationsCode> list = new ArrayList<AttPuaSkriptOperationsCode>();
		list.add(ZUSTAND_1_ANLEGEN);
		list.add(ZUSTAND_2_QUELLTEXT);
		list.add(ZUSTAND_3_STANDARD_WERTE);
		list.add(ZUSTAND_100_FEHLER);
		list.add(ZUSTAND_200_QUITTUNG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut OperationsCode.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttPuaSkriptOperationsCode(final 		Short
	 value) {
		super(value);
	}
	
	private AttPuaSkriptOperationsCode(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
