/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Erzeuge-Antwort von Simulationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlErzeugeSimulationAntwort implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
			 _referenzErzeugteSimulation
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationZustand
			 _erzeugeSimulationZustand
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationFehler
			 _erzeugeSimulationFehler
			;
	
		/**
		Referenz der erzeugten Simulation.
		<p>
		&lt;absatz&gt;
									Wenn die Simulation nicht erzeugt werden konnte, wir dies im Attribut 'Zustand' gemeldet und diese Referenz wird nicht apezifiziert.
								&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von ReferenzErzeugteSimulation.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
			 getReferenzErzeugteSimulation() {
			return _referenzErzeugteSimulation;
		}
	
		/**
		Referenz der erzeugten Simulation.
		<p>
		&lt;absatz&gt;
									Wenn die Simulation nicht erzeugt werden konnte, wir dies im Attribut 'Zustand' gemeldet und diese Referenz wird nicht apezifiziert.
								&lt;&#47;absatz&gt;
		</p>
		
		@param _referenzErzeugteSimulation der neue Wert von ReferenzErzeugteSimulation.
		*/
		public void setReferenzErzeugteSimulation(	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
		 _referenzErzeugteSimulation) {
			this._referenzErzeugteSimulation = _referenzErzeugteSimulation;
		}
	
		/**
		Zustand nach Erzeuge-Anforderung einer Simulation.
		<p>
		
		</p>
		
		@return der Wert von ErzeugeSimulationZustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationZustand
			 getErzeugeSimulationZustand() {
			return _erzeugeSimulationZustand;
		}
	
		/**
		Zustand nach Erzeuge-Anforderung einer Simulation.
		<p>
		
		</p>
		
		@param _erzeugeSimulationZustand der neue Wert von ErzeugeSimulationZustand.
		*/
		public void setErzeugeSimulationZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationZustand
		 _erzeugeSimulationZustand) {
			this._erzeugeSimulationZustand = _erzeugeSimulationZustand;
		}
	
		/**
		Fehler-Status nach Erzeuge-Anforderung einer Simulation.
		<p>
		
		</p>
		
		@return der Wert von ErzeugeSimulationFehler.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationFehler
			 getErzeugeSimulationFehler() {
			return _erzeugeSimulationFehler;
		}
	
		/**
		Fehler-Status nach Erzeuge-Anforderung einer Simulation.
		<p>
		
		</p>
		
		@param _erzeugeSimulationFehler der neue Wert von ErzeugeSimulationFehler.
		*/
		public void setErzeugeSimulationFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationFehler
		 _erzeugeSimulationFehler) {
			this._erzeugeSimulationFehler = _erzeugeSimulationFehler;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soReferenzErzeugteSimulation = getReferenzErzeugteSimulation();
					final SystemObject tmpReferenzErzeugteSimulation;
						if (soReferenzErzeugteSimulation instanceof SystemObject) {
							tmpReferenzErzeugteSimulation = (SystemObject)soReferenzErzeugteSimulation;
						} else if(soReferenzErzeugteSimulation instanceof SystemObjekt){
							tmpReferenzErzeugteSimulation = ((SystemObjekt)soReferenzErzeugteSimulation).getSystemObject();
						} else{
							tmpReferenzErzeugteSimulation = null;
						}
					datum.getReferenceValue("ReferenzErzeugteSimulation").setSystemObject(tmpReferenzErzeugteSimulation);
				// GanzzahlAttributTyp
				if (getErzeugeSimulationZustand() != null) {
	                if (getErzeugeSimulationZustand().isZustand()) {
	                    datum.getUnscaledValue("ErzeugeSimulationZustand").setText(getErzeugeSimulationZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ErzeugeSimulationZustand").set(getErzeugeSimulationZustand().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getErzeugeSimulationFehler() != null) {
	                if (getErzeugeSimulationFehler().isZustand()) {
	                    datum.getUnscaledValue("ErzeugeSimulationFehler").setText(getErzeugeSimulationFehler().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ErzeugeSimulationFehler").set(getErzeugeSimulationFehler().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idReferenzErzeugteSimulation = daten.getReferenceValue("ReferenzErzeugteSimulation").getId();
					final SystemObjekt tmpReferenzErzeugteSimulation;
					if (idReferenzErzeugteSimulation == 0) {
						tmpReferenzErzeugteSimulation = null;
					} else {
						final SystemObject soReferenzErzeugteSimulation = factory.getDav().getDataModel().getObject(idReferenzErzeugteSimulation);
						if (soReferenzErzeugteSimulation == null) {
								tmpReferenzErzeugteSimulation = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.impl.SimulationUngueltig(idReferenzErzeugteSimulation);
						} else {
							tmpReferenzErzeugteSimulation = factory.getModellobjekt(soReferenzErzeugteSimulation);
						}
					}
					setReferenzErzeugteSimulation((	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
					) tmpReferenzErzeugteSimulation);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ErzeugeSimulationZustand").isState()) {
							setErzeugeSimulationZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationZustand
							.getZustand(daten.getScaledValue("ErzeugeSimulationZustand").getText()));
						} else {
						setErzeugeSimulationZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationZustand
						(daten.
							getUnscaledValue
						("ErzeugeSimulationZustand").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ErzeugeSimulationFehler").isState()) {
							setErzeugeSimulationFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationFehler
							.getZustand(daten.getScaledValue("ErzeugeSimulationFehler").getText()));
						} else {
						setErzeugeSimulationFehler(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttErzeugeSimulationFehler
						(daten.
							getUnscaledValue
						("ErzeugeSimulationFehler").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlErzeugeSimulationAntwort clone() {
		AtlErzeugeSimulationAntwort klon = new AtlErzeugeSimulationAntwort();
		
						klon.setReferenzErzeugteSimulation(getReferenzErzeugteSimulation());
						klon.setErzeugeSimulationZustand(getErzeugeSimulationZustand());
						klon.setErzeugeSimulationFehler(getErzeugeSimulationFehler());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
