/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lösche-Anforderung von Simulationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlLoescheSimulationAnfrage implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
			 _referenzZuLoeschendeSimulation
			;
	
		/**
		Referenz der zu loeschenden Simulation.
		<p>
		
		</p>
		
		@return der Wert von ReferenzZuLoeschendeSimulation.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
			 getReferenzZuLoeschendeSimulation() {
			return _referenzZuLoeschendeSimulation;
		}
	
		/**
		Referenz der zu loeschenden Simulation.
		<p>
		
		</p>
		
		@param _referenzZuLoeschendeSimulation der neue Wert von ReferenzZuLoeschendeSimulation.
		*/
		public void setReferenzZuLoeschendeSimulation(	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
		 _referenzZuLoeschendeSimulation) {
			this._referenzZuLoeschendeSimulation = _referenzZuLoeschendeSimulation;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soReferenzZuLoeschendeSimulation = getReferenzZuLoeschendeSimulation();
					final SystemObject tmpReferenzZuLoeschendeSimulation;
						if (soReferenzZuLoeschendeSimulation instanceof SystemObject) {
							tmpReferenzZuLoeschendeSimulation = (SystemObject)soReferenzZuLoeschendeSimulation;
						} else if(soReferenzZuLoeschendeSimulation instanceof SystemObjekt){
							tmpReferenzZuLoeschendeSimulation = ((SystemObjekt)soReferenzZuLoeschendeSimulation).getSystemObject();
						} else{
							tmpReferenzZuLoeschendeSimulation = null;
						}
					datum.getReferenceValue("ReferenzZuLoeschendeSimulation").setSystemObject(tmpReferenzZuLoeschendeSimulation);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idReferenzZuLoeschendeSimulation = daten.getReferenceValue("ReferenzZuLoeschendeSimulation").getId();
					final SystemObjekt tmpReferenzZuLoeschendeSimulation;
					if (idReferenzZuLoeschendeSimulation == 0) {
						tmpReferenzZuLoeschendeSimulation = null;
					} else {
						final SystemObject soReferenzZuLoeschendeSimulation = factory.getDav().getDataModel().getObject(idReferenzZuLoeschendeSimulation);
						if (soReferenzZuLoeschendeSimulation == null) {
								tmpReferenzZuLoeschendeSimulation = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.impl.SimulationUngueltig(idReferenzZuLoeschendeSimulation);
						} else {
							tmpReferenzZuLoeschendeSimulation = factory.getModellobjekt(soReferenzZuLoeschendeSimulation);
						}
					}
					setReferenzZuLoeschendeSimulation((	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
					) tmpReferenzZuLoeschendeSimulation);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlLoescheSimulationAnfrage clone() {
		AtlLoescheSimulationAnfrage klon = new AtlLoescheSimulationAnfrage();
		
						klon.setReferenzZuLoeschendeSimulation(getReferenzZuLoeschendeSimulation());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
