/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zeitbereich für die Offline-Simulation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlOfflineSimulationsZeitbereich implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _simulationsBeginn
			;
			private 	Zeitstempel
			 _simulationsEnde
			;
	
		/**
		Startzeitpunkt der Simulation.
		<p>
		
		</p>
		
		@return der Wert von SimulationsBeginn.
		*/
			public 	Zeitstempel
			 getSimulationsBeginn() {
			return _simulationsBeginn;
		}
	
		/**
		Startzeitpunkt der Simulation.
		<p>
		
		</p>
		
		@param _simulationsBeginn der neue Wert von SimulationsBeginn.
		*/
		public void setSimulationsBeginn(	Zeitstempel
		 _simulationsBeginn) {
			this._simulationsBeginn = _simulationsBeginn;
		}
	
		/**
		Endzeitpunkt der Simulation.
		<p>
		
		</p>
		
		@return der Wert von SimulationsEnde.
		*/
			public 	Zeitstempel
			 getSimulationsEnde() {
			return _simulationsEnde;
		}
	
		/**
		Endzeitpunkt der Simulation.
		<p>
		
		</p>
		
		@param _simulationsEnde der neue Wert von SimulationsEnde.
		*/
		public void setSimulationsEnde(	Zeitstempel
		 _simulationsEnde) {
			this._simulationsEnde = _simulationsEnde;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("SimulationsBeginn").setMillis(getSimulationsBeginn().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("SimulationsEnde").setMillis(getSimulationsEnde().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setSimulationsBeginn(new
						Zeitstempel
						(daten.getTimeValue("SimulationsBeginn").getMillis()));
				// ZeitstempelAttributTyp
					setSimulationsEnde(new
						Zeitstempel
						(daten.getTimeValue("SimulationsEnde").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlOfflineSimulationsZeitbereich clone() {
		AtlOfflineSimulationsZeitbereich klon = new AtlOfflineSimulationsZeitbereich();
		
						klon.setSimulationsBeginn(getSimulationsBeginn());
						klon.setSimulationsEnde(getSimulationsEnde());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
