/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Spezifikation der benötigten Simulationseingangsdaten und Parameter.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlParameterSatzSimulationsdaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> _bereich = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
			> _eingangsdaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlParameterSpezifikationen
			> _datenSpezifikation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlParameterSpezifikationen
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEinstellungenParametrierung
			 _einstellungen
			= new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEinstellungenParametrierung
			()
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			> _simulationsmengen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
			> _dynamischeSimulationsObjekte = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
			>(0, true);
	
		/**
		Die in der folgenden Attributliste "Eingangsdaten" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
								Konfigurationsbereich (Kein Eintrag: Alle Konfigurationsbereiche).
		<p>
		
		</p>
		
		@return der Wert von Bereich.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> getBereich() {
			return _bereich;
		}
	
	
		/**
		Mit dieser Attributliste werden die Eingangsdaten spezifiziert, die vom Simulationsdatengenerator bei einer Simulation unter der
								entsprechenden Variante eingespeist werden müssen. Bei einer Online-Simulation werden die aktuellen Daten für die Simulation in die
								entsprechende Simulationsvariante kopiert, bei der Offline-Simulation werden die Daten für den gewünschten Zeitbereich beim Archivsystem
								angefordert und für die Simulation eingespeist.
		<p>
		
		</p>
		
		@return der Wert von Eingangsdaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
			> getEingangsdaten() {
			return _eingangsdaten;
		}
	
	
		/**
		Die Parametrierung muss die von den Applikationen benötigten Parameter in der entsprechenden Simulationsvariante bereitstellen. Die
								benötigten Parameter werden mit dieser Attributliste spezifiziert.
		<p>
		
		</p>
		
		@return der Wert von DatenSpezifikation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlParameterSpezifikationen
			> getDatenSpezifikation() {
			return _datenSpezifikation;
		}
	
	
		/**
		Attributliste mit der festgelegt werden kann, ob die im Attribut DatenSpezifikation angegebenen Parameter von der Parametrierung
								berücksichtigt werden sollen.
		<p>
		
		</p>
		
		@return der Wert von Einstellungen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEinstellungenParametrierung
			 getEinstellungen() {
			return _einstellungen;
		}
	
		/**
		Attributliste mit der festgelegt werden kann, ob die im Attribut DatenSpezifikation angegebenen Parameter von der Parametrierung
								berücksichtigt werden sollen.
		<p>
		
		</p>
		
		@param _einstellungen der neue Wert von Einstellungen.
		*/
		public void setEinstellungen(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEinstellungenParametrierung
		 _einstellungen) {
			this._einstellungen = _einstellungen;
		}
	
		/**
		Ein Array, das alle Mengentypen speichert, deren Mengen in einer Simulation besonders behandelt werden sollen.
		<p>
		Wenn eine Simulation für einen Menge eines hier aufgeführten Mengentyp ein Element erzeugt und hinzufügt, so wird das Element
								in der Simulationsvariante der Simulation zur Menge hinzugefügt. Fordert die Simulation die Elemente der Menge an, so erhält sie nur die
								Elemente, die ihrer Simulationsvariante entsprechen. Fordert eine normale Applikation Elemente der Menge an, so erhält sie alle Elemente
								der Simulationsvariante 0, nicht aber das Element, das durch die Simulation hinzugefügt wurde. Bei allen Mengen deren Mengetypen hier
								nicht aufgeführt sind, darf die Simulation keine Elemente zu der Menge hinzufügen. Fordert die Simulation für diese Mengen die Elemente
								an, so wird sie die aktuellen Elemente der Menge mit Simulationsvariante 0 erhalten.
		</p>
		
		@return der Wert von Simulationsmengen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			> getSimulationsmengen() {
			return _simulationsmengen;
		}
	
	
		/**
		Ein Array, das dynamischen Objekttypen speichert. Alle Zugriffe(erzeugen&#47;ändern) auf dynamische Objekte dieser Typen finden unter
								Berücksichtigung der Simulationsvariante der Simulation statt (TPuK 1-44, 1-122).
		<p>
		
		</p>
		
		@return der Wert von DynamischeSimulationsObjekte.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
			> getDynamischeSimulationsObjekte() {
			return _dynamischeSimulationsObjekte;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBereich = datum.getReferenceArray("Bereich");
					arrayBereich.setLength(getBereich().size());
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						final Object soBereich = getBereich().get(i);
						final SystemObject tmpBereich;
						if (soBereich instanceof SystemObject) {
							tmpBereich = (SystemObject)soBereich;
						} else if(soBereich instanceof SystemObjekt){
							tmpBereich = ((SystemObjekt)soBereich).getSystemObject();
						} else{
							tmpBereich = null;
						}
						arrayBereich.getReferenceValue(i).setSystemObject(tmpBereich);
					}
				// AttributListenDefinition
					final Data.Array arrayEingangsdaten = datum.getArray("Eingangsdaten");
					arrayEingangsdaten.setLength(getEingangsdaten().size());
					for (int i = 0; i < arrayEingangsdaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
						 atl = getEingangsdaten().get(i);
						atl.bean2Atl(arrayEingangsdaten.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayDatenSpezifikation = datum.getArray("DatenSpezifikation");
					arrayDatenSpezifikation.setLength(getDatenSpezifikation().size());
					for (int i = 0; i < arrayDatenSpezifikation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlParameterSpezifikationen
						 atl = getDatenSpezifikation().get(i);
						atl.bean2Atl(arrayDatenSpezifikation.getItem(i), factory);
	
					}
				// AttributListenDefinition
					getEinstellungen().bean2Atl(datum.getItem("Einstellungen"), factory);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arraySimulationsmengen = datum.getReferenceArray("Simulationsmengen");
					arraySimulationsmengen.setLength(getSimulationsmengen().size());
					for (int i = 0; i < arraySimulationsmengen.getLength(); ++i) {
						final Object soSimulationsmengen = getSimulationsmengen().get(i);
						final SystemObject tmpSimulationsmengen;
						if (soSimulationsmengen instanceof SystemObject) {
							tmpSimulationsmengen = (SystemObject)soSimulationsmengen;
						} else if(soSimulationsmengen instanceof SystemObjekt){
							tmpSimulationsmengen = ((SystemObjekt)soSimulationsmengen).getSystemObject();
						} else{
							tmpSimulationsmengen = null;
						}
						arraySimulationsmengen.getReferenceValue(i).setSystemObject(tmpSimulationsmengen);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayDynamischeSimulationsObjekte = datum.getReferenceArray("DynamischeSimulationsObjekte");
					arrayDynamischeSimulationsObjekte.setLength(getDynamischeSimulationsObjekte().size());
					for (int i = 0; i < arrayDynamischeSimulationsObjekte.getLength(); ++i) {
						final Object soDynamischeSimulationsObjekte = getDynamischeSimulationsObjekte().get(i);
						final SystemObject tmpDynamischeSimulationsObjekte;
						if (soDynamischeSimulationsObjekte instanceof SystemObject) {
							tmpDynamischeSimulationsObjekte = (SystemObject)soDynamischeSimulationsObjekte;
						} else if(soDynamischeSimulationsObjekte instanceof SystemObjekt){
							tmpDynamischeSimulationsObjekte = ((SystemObjekt)soDynamischeSimulationsObjekte).getSystemObject();
						} else{
							tmpDynamischeSimulationsObjekte = null;
						}
						arrayDynamischeSimulationsObjekte.getReferenceValue(i).setSystemObject(tmpDynamischeSimulationsObjekte);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBereich = daten.getReferenceArray("Bereich");
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						final long idBereich = daten.getReferenceArray("Bereich").getReferenceValue(i).getId();
						final SystemObjekt tmpBereich;
						if (idBereich == 0) {
							tmpBereich = null;
						} else {
							final SystemObject soBereich = factory.getDav().getDataModel().getObject(idBereich);
							if (soBereich == null) {
									tmpBereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idBereich);
							} else {
								tmpBereich = factory.getModellobjekt(soBereich);
							}
						}
							getBereich().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
							) tmpBereich);
					}
				// AttributListenDefinition
					final Data.Array arrayEingangsdaten = daten.getArray("Eingangsdaten");
					for (int i = 0; i < arrayEingangsdaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
						 ();
						atl.atl2Bean(arrayEingangsdaten.getItem(i), factory);
						getEingangsdaten().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayDatenSpezifikation = daten.getArray("DatenSpezifikation");
					for (int i = 0; i < arrayDatenSpezifikation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlParameterSpezifikationen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlParameterSpezifikationen
						 ();
						atl.atl2Bean(arrayDatenSpezifikation.getItem(i), factory);
						getDatenSpezifikation().add(atl);
					}
				// AttributListenDefinition
					getEinstellungen().atl2Bean(daten.getItem("Einstellungen"), factory);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arraySimulationsmengen = daten.getReferenceArray("Simulationsmengen");
					for (int i = 0; i < arraySimulationsmengen.getLength(); ++i) {
						final long idSimulationsmengen = daten.getReferenceArray("Simulationsmengen").getReferenceValue(i).getId();
						final SystemObjekt tmpSimulationsmengen;
						if (idSimulationsmengen == 0) {
							tmpSimulationsmengen = null;
						} else {
							final SystemObject soSimulationsmengen = factory.getDav().getDataModel().getObject(idSimulationsmengen);
							if (soSimulationsmengen == null) {
									tmpSimulationsmengen = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.MengenTypUngueltig(idSimulationsmengen);
							} else {
								tmpSimulationsmengen = factory.getModellobjekt(soSimulationsmengen);
							}
						}
							getSimulationsmengen().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
							) tmpSimulationsmengen);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayDynamischeSimulationsObjekte = daten.getReferenceArray("DynamischeSimulationsObjekte");
					for (int i = 0; i < arrayDynamischeSimulationsObjekte.getLength(); ++i) {
						final long idDynamischeSimulationsObjekte = daten.getReferenceArray("DynamischeSimulationsObjekte").getReferenceValue(i).getId();
						final SystemObjekt tmpDynamischeSimulationsObjekte;
						if (idDynamischeSimulationsObjekte == 0) {
							tmpDynamischeSimulationsObjekte = null;
						} else {
							final SystemObject soDynamischeSimulationsObjekte = factory.getDav().getDataModel().getObject(idDynamischeSimulationsObjekte);
							if (soDynamischeSimulationsObjekte == null) {
									tmpDynamischeSimulationsObjekte = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.DynamischerTypUngueltig(idDynamischeSimulationsObjekte);
							} else {
								tmpDynamischeSimulationsObjekte = factory.getModellobjekt(soDynamischeSimulationsObjekte);
							}
						}
							getDynamischeSimulationsObjekte().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
							) tmpDynamischeSimulationsObjekte);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterSatzSimulationsdaten clone() {
		AtlParameterSatzSimulationsdaten klon = new AtlParameterSatzSimulationsdaten();
		
					klon._bereich = getBereich().clone();
					klon._eingangsdaten = getEingangsdaten().clone();
					klon._datenSpezifikation = getDatenSpezifikation().clone();
						klon._einstellungen = getEinstellungen().clone();
					klon._simulationsmengen = getSimulationsmengen().clone();
					klon._dynamischeSimulationsObjekte = getDynamischeSimulationsObjekte().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
