/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Spezifikation zu archivierenden Simulationsdaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSimulationsDatenArchivierung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> _bereich = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
			> _eingangsdaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			> _quittieren = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			>(1, true);
	
		/**
		Die in der folgenden Attributliste "Eingangsdaten" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
								Konfigurationsbereich (Kein Eintrag: Alle Konfigurationsbereiche).
		<p>
		
		</p>
		
		@return der Wert von Bereich.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> getBereich() {
			return _bereich;
		}
	
	
		/**
		Mit dieser Attributliste werden die zu archivierenden Simulationsdaten spezifiziert.
		<p>
		
		</p>
		
		@return der Wert von Eingangsdaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
			> getEingangsdaten() {
			return _eingangsdaten;
		}
	
	
		/**
		Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu quittieren sind. In diesem Fall wird an dieser Stelle der Aspekt
								spezifiziert, unter dem die entsprechenden Attributgruppen nach erfolgreicher Archivierung mit der entsprechenden Simulationsvariante
								publiziert werden.
		<p>
		
		</p>
		
		@return der Wert von Quittieren.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			> getQuittieren() {
			return _quittieren;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBereich = datum.getReferenceArray("Bereich");
					arrayBereich.setLength(getBereich().size());
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						final Object soBereich = getBereich().get(i);
						final SystemObject tmpBereich;
						if (soBereich instanceof SystemObject) {
							tmpBereich = (SystemObject)soBereich;
						} else if(soBereich instanceof SystemObjekt){
							tmpBereich = ((SystemObjekt)soBereich).getSystemObject();
						} else{
							tmpBereich = null;
						}
						arrayBereich.getReferenceValue(i).setSystemObject(tmpBereich);
					}
				// AttributListenDefinition
					final Data.Array arrayEingangsdaten = datum.getArray("Eingangsdaten");
					arrayEingangsdaten.setLength(getEingangsdaten().size());
					for (int i = 0; i < arrayEingangsdaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
						 atl = getEingangsdaten().get(i);
						atl.bean2Atl(arrayEingangsdaten.getItem(i), factory);
	
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayQuittieren = datum.getReferenceArray("Quittieren");
					arrayQuittieren.setLength(getQuittieren().size());
					for (int i = 0; i < arrayQuittieren.getLength(); ++i) {
						final Object soQuittieren = getQuittieren().get(i);
						final SystemObject tmpQuittieren;
						if (soQuittieren instanceof SystemObject) {
							tmpQuittieren = (SystemObject)soQuittieren;
						} else if(soQuittieren instanceof SystemObjekt){
							tmpQuittieren = ((SystemObjekt)soQuittieren).getSystemObject();
						} else{
							tmpQuittieren = null;
						}
						arrayQuittieren.getReferenceValue(i).setSystemObject(tmpQuittieren);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBereich = daten.getReferenceArray("Bereich");
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						final long idBereich = daten.getReferenceArray("Bereich").getReferenceValue(i).getId();
						final SystemObjekt tmpBereich;
						if (idBereich == 0) {
							tmpBereich = null;
						} else {
							final SystemObject soBereich = factory.getDav().getDataModel().getObject(idBereich);
							if (soBereich == null) {
									tmpBereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idBereich);
							} else {
								tmpBereich = factory.getModellobjekt(soBereich);
							}
						}
							getBereich().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
							) tmpBereich);
					}
				// AttributListenDefinition
					final Data.Array arrayEingangsdaten = daten.getArray("Eingangsdaten");
					for (int i = 0; i < arrayEingangsdaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlDatenSpezifikationen
						 ();
						atl.atl2Bean(arrayEingangsdaten.getItem(i), factory);
						getEingangsdaten().add(atl);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayQuittieren = daten.getReferenceArray("Quittieren");
					for (int i = 0; i < arrayQuittieren.getLength(); ++i) {
						final long idQuittieren = daten.getReferenceArray("Quittieren").getReferenceValue(i).getId();
						final SystemObjekt tmpQuittieren;
						if (idQuittieren == 0) {
							tmpQuittieren = null;
						} else {
							final SystemObject soQuittieren = factory.getDav().getDataModel().getObject(idQuittieren);
							if (soQuittieren == null) {
									tmpQuittieren = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idQuittieren);
							} else {
								tmpQuittieren = factory.getModellobjekt(soQuittieren);
							}
						}
							getQuittieren().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
							) tmpQuittieren);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSimulationsDatenArchivierung clone() {
		AtlSimulationsDatenArchivierung klon = new AtlSimulationsDatenArchivierung();
		
					klon._bereich = getBereich().clone();
					klon._eingangsdaten = getEingangsdaten().clone();
					klon._quittieren = getQuittieren().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
