/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen über Start-&#47;Stop-Blöcke und die zugeordenteten Rechner für diese Simulationsstrecke.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlStartInfo implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.objekte.Rechner
			 _rechner
			;
			private String
			 _startskript
			= new String
			()
			;
	
		/**
		Rechner, auf dem Applikationen für diese Simulationsstrecke gestartet werden können.
		<p>
		
		</p>
		
		@return der Wert von Rechner.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.objekte.Rechner
			 getRechner() {
			return _rechner;
		}
	
		/**
		Rechner, auf dem Applikationen für diese Simulationsstrecke gestartet werden können.
		<p>
		
		</p>
		
		@param _rechner der neue Wert von Rechner.
		*/
		public void setRechner(	de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.objekte.Rechner
		 _rechner) {
			this._rechner = _rechner;
		}
	
		/**
		Start-&#47;Stop-Block dieser Simulationsstrecke für einen Rechner.
		<p>
		
		</p>
		
		@return der Wert von Startskript.
		*/
			public String
			 getStartskript() {
			return _startskript;
		}
	
		/**
		Start-&#47;Stop-Block dieser Simulationsstrecke für einen Rechner.
		<p>
		
		</p>
		
		@param _startskript der neue Wert von Startskript.
		*/
		public void setStartskript(String
		 _startskript) {
			if (_startskript.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._startskript = _startskript;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soRechner = getRechner();
					final SystemObject tmpRechner;
						if (soRechner instanceof SystemObject) {
							tmpRechner = (SystemObject)soRechner;
						} else if(soRechner instanceof SystemObjekt){
							tmpRechner = ((SystemObjekt)soRechner).getSystemObject();
						} else{
							tmpRechner = null;
						}
					datum.getReferenceValue("Rechner").setSystemObject(tmpRechner);
				// ZeichenkettenAttributTyp
				if (getStartskript() != null) {
					datum.getTextValue("Startskript").setText(getStartskript());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idRechner = daten.getReferenceValue("Rechner").getId();
					final SystemObjekt tmpRechner;
					if (idRechner == 0) {
						tmpRechner = null;
					} else {
						final SystemObject soRechner = factory.getDav().getDataModel().getObject(idRechner);
						if (soRechner == null) {
								tmpRechner = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.objekte.impl.RechnerUngueltig(idRechner);
						} else {
							tmpRechner = factory.getModellobjekt(soRechner);
						}
					}
					setRechner((	de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.objekte.Rechner
					) tmpRechner);
				// ZeichenkettenAttributTyp
					setStartskript(daten.getTextValue("Startskript").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStartInfo clone() {
		AtlStartInfo klon = new AtlStartInfo();
		
						klon.setRechner(getRechner());
						klon.setStartskript(getStartskript());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
