/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fehler-Status nach Loesche-Anforderung einer Simulation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AttLoescheSimulationFehler extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Anfrage fehlerfrei durchgeführt.
	<p>
	
	</p>
	*/
	public static final AttLoescheSimulationFehler ZUSTAND_0_KEIN_FEHLER = new AttLoescheSimulationFehler("Kein Fehler", 		Byte
	.valueOf("0"));

	/**
	Simulationen ist nicht in adäquatem Zustand, um gelöscht werden.
	<p>
	
	</p>
	*/
	public static final AttLoescheSimulationFehler ZUSTAND_1_KEIN_ADAEQUATER_ZUSTAND = new AttLoescheSimulationFehler("Kein adäquater Zustand", 		Byte
	.valueOf("1"));

	/**
	Angegebenes Simulationsobjekt ist nicht bei den von der SWE verwalteten Simulationen.
	<p>
	
	</p>
	*/
	public static final AttLoescheSimulationFehler ZUSTAND_2_SIMULATION_NICHT_GEFUNDEN = new AttLoescheSimulationFehler("Simulation nicht gefunden", 		Byte
	.valueOf("2"));

	/**
	Objekttreferenz ist zum Löschen einer Sinulation ungültig.
	<p>
	
	</p>
	*/
	public static final AttLoescheSimulationFehler ZUSTAND_3_UNGUELTIGES_OBJEKT = new AttLoescheSimulationFehler("Ungültiges Objekt", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttLoescheSimulationFehler getZustand(final 		Byte
	 value) {
		for (AttLoescheSimulationFehler e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttLoescheSimulationFehler getZustand(final String value) {
		for (AttLoescheSimulationFehler e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttLoescheSimulationFehler> getZustaende() {
		List<AttLoescheSimulationFehler> list = new ArrayList<AttLoescheSimulationFehler>();
		list.add(ZUSTAND_0_KEIN_FEHLER);
		list.add(ZUSTAND_1_KEIN_ADAEQUATER_ZUSTAND);
		list.add(ZUSTAND_2_SIMULATION_NICHT_GEFUNDEN);
		list.add(ZUSTAND_3_UNGUELTIGES_OBJEKT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut LoescheSimulationFehler.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttLoescheSimulationFehler(final 		Byte
	 value) {
		super(value);
	}
	
	private AttLoescheSimulationFehler(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
