/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekte (zur Verwaltung) von Offline-Simulationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface OfflineSimulation extends de.bsvrz.sys.funclib.bitctrl.modell.DynamischesObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.offlineSimulation"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Statusinformation Archiv für die Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsStatusArchiv.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusArchiv getOdSimulationsStatusArchiv();
	
	/**
	Steuervorgaben für die Offline-Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsSteuerungOffline.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsSteuerungOffline getOdSimulationsSteuerungOffline();
	
	/**
	Statusinformation Parametrierung für die Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsStatusParametrierung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusParametrierung getOdSimulationsStatusParametrierung();
	
	/**
	Konfigurierende Eigenschaften einer Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.konfigurationsdaten.KdSimulationsEigenschaften getKdSimulationsEigenschaften();
	
	/**
	Enthält Informationen, wenn dieses Objekt mit KExDaV übertragen wurde und von einer anderen Konfiguration stammt.
	<p>
	
	</p>
	@return der Datensatz KexdavAustauschObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKexdavAustauschObjekt getKdKexdavAustauschObjekt();
	
	/**
	Statusinformation Start&#47;Stopp für die Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsStatusStartStopp.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusStartStopp getOdSimulationsStatusStartStopp();
	
	/**
	Enthält die Simulationszeit für eine Simulationsvariante.
	<p>
	Wird von der Simulationsverwaltung neben den für eine Simulation notwendigen Daten publiziert, damit den in einer Simulations
						arbeitenden Applikationen die"aktuelle" Simulationszeit übermittelt wird. Über den DAF werden Methoden zur Verfügung gestellt, mittels derer
						eine Applikation diese Zeit abfragen kann. Falls eine Funktion nicht in einer Simualtionsumgebung läuft oder aber eine online-Simulation
						durchführt, liefert die entsprechende Methode die aktuelle Systemzeit zurück. Es stehen weiterhin Mehtoden im DAF für die Apllikationen
						bereit, die ein"sleep()" zur Verfügung stellen, so dass auch diese Funktionalität im Rahmen einer Simulation automatisch im richtigen
						Zeitkontext erfolgt. Auch diese Mewthoden verwenden die Information dieser Attributgruppe.
	</p>
	@return der Datensatz SimulationsZeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdSimulationsZeit getOdSimulationsZeit();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Statusinformation Konfiguration für die Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsStatusKonfiguration.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusKonfiguration getOdSimulationsStatusKonfiguration();
	
	/**
	Infos über die gestarteten Start&#47;-Stop-Blöcke als Parameter.
	<p>
	
	</p>
	@return der Datensatz SimulationStartInfo.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.parameter.PdSimulationStartInfo getPdSimulationStartInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Zeitbereich für die Offline-Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsZeitBereich.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsZeitBereich getOdSimulationsZeitBereich();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
