/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zur Übermittlung von Antworten auf Verwaltungsanfragen für Simulationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class OdSimulationVerwaltungAntwort extends AbstractOnlineDatensatz<OdSimulationVerwaltungAntwort.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _absenderZeichen
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlErzeugeSimulationAntwort
				> _erzeugeSimulationAntwort = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlErzeugeSimulationAntwort
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlLoescheSimulationAntwort
				> _loescheSimulationAntwort = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlLoescheSimulationAntwort
				>(0, true);
		
			/**
			Kennzeichnung, die von der anfragenden Applikation vergeben wurde, wird hier zurückgegeben.
			<p>
			
			</p>
			
			@return der Wert von AbsenderZeichen.
			*/
				public String
				 getAbsenderZeichen() {
				return _absenderZeichen;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation vergeben wurde, wird hier zurückgegeben.
			<p>
			
			</p>
			
			@param _absenderZeichen der neue Wert von AbsenderZeichen.
			*/
			public void setAbsenderZeichen(String
			 _absenderZeichen) {
				if (_absenderZeichen.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._absenderZeichen = _absenderZeichen;
			}
		
			/**
			Informationen zur Erzeuge-Anforderung von Simulationen.
			<p>
			
			</p>
			
			@return der Wert von ErzeugeSimulationAntwort.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlErzeugeSimulationAntwort
				> getErzeugeSimulationAntwort() {
				return _erzeugeSimulationAntwort;
			}
		
		
			/**
			Informationen zur Lösch-Anforderung für Simulationen.
			<p>
			
			</p>
			
			@return der Wert von LoescheSimulationAntwort.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlLoescheSimulationAntwort
				> getLoescheSimulationAntwort() {
				return _loescheSimulationAntwort;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getAbsenderZeichen() != null) {
						datum.getTextValue("AbsenderZeichen").setText(getAbsenderZeichen());
					}
					// AttributListenDefinition
						final Data.Array arrayErzeugeSimulationAntwort = datum.getArray("ErzeugeSimulationAntwort");
						arrayErzeugeSimulationAntwort.setLength(getErzeugeSimulationAntwort().size());
						for (int i = 0; i < arrayErzeugeSimulationAntwort.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlErzeugeSimulationAntwort
							 atl = getErzeugeSimulationAntwort().get(i);
							atl.bean2Atl(arrayErzeugeSimulationAntwort.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayLoescheSimulationAntwort = datum.getArray("LoescheSimulationAntwort");
						arrayLoescheSimulationAntwort.setLength(getLoescheSimulationAntwort().size());
						for (int i = 0; i < arrayLoescheSimulationAntwort.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlLoescheSimulationAntwort
							 atl = getLoescheSimulationAntwort().get(i);
							atl.bean2Atl(arrayLoescheSimulationAntwort.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setAbsenderZeichen(daten.getTextValue("AbsenderZeichen").getText());
					// AttributListenDefinition
						final Data.Array arrayErzeugeSimulationAntwort = daten.getArray("ErzeugeSimulationAntwort");
						for (int i = 0; i < arrayErzeugeSimulationAntwort.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlErzeugeSimulationAntwort
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlErzeugeSimulationAntwort
							 ();
							atl.atl2Bean(arrayErzeugeSimulationAntwort.getItem(i), factory);
							getErzeugeSimulationAntwort().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayLoescheSimulationAntwort = daten.getArray("LoescheSimulationAntwort");
						for (int i = 0; i < arrayLoescheSimulationAntwort.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlLoescheSimulationAntwort
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlLoescheSimulationAntwort
							 ();
							atl.atl2Bean(arrayLoescheSimulationAntwort.getItem(i), factory);
							getLoescheSimulationAntwort().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsenderZeichen(getAbsenderZeichen());
						klon._erzeugeSimulationAntwort = getErzeugeSimulationAntwort().clone();
						klon._loescheSimulationAntwort = getLoescheSimulationAntwort().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.simulationVerwaltungAntwort";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdSimulationVerwaltungAntwort(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
