/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvizconnect.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eigenschaften einer VIZ-Kamera.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdVizKamera extends AbstractKonfigurationsDatensatz<KdVizKamera.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _vorschauURI
				= new String
				()
				;
				private String
				 _bildURI
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				 _strasse
				;
				private String
				 _blickrichtung
				= new String
				()
				;
				private String
				 _bereich
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _winkel
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _index
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von VorschauURI.
			*/
				public String
				 getVorschauURI() {
				return _vorschauURI;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _vorschauURI der neue Wert von VorschauURI.
			*/
			public void setVorschauURI(String
			 _vorschauURI) {
				if (_vorschauURI.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._vorschauURI = _vorschauURI;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von BildURI.
			*/
				public String
				 getBildURI() {
				return _bildURI;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bildURI der neue Wert von BildURI.
			*/
			public void setBildURI(String
			 _bildURI) {
				if (_bildURI.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bildURI = _bildURI;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.straße.
			<p>
			
			</p>
			
			@return der Wert von Strasse.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				 getStrasse() {
				return _strasse;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.straße.
			<p>
			
			</p>
			
			@param _strasse der neue Wert von Strasse.
			*/
			public void setStrasse(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
			 _strasse) {
				this._strasse = _strasse;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Blickrichtung.
			*/
				public String
				 getBlickrichtung() {
				return _blickrichtung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _blickrichtung der neue Wert von Blickrichtung.
			*/
			public void setBlickrichtung(String
			 _blickrichtung) {
				if (_blickrichtung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._blickrichtung = _blickrichtung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Bereich.
			*/
				public String
				 getBereich() {
				return _bereich;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bereich der neue Wert von Bereich.
			*/
			public void setBereich(String
			 _bereich) {
				if (_bereich.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bereich = _bereich;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Winkel.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getWinkel() {
				return _winkel;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _winkel der neue Wert von Winkel.
			*/
			public void setWinkel(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _winkel) {
				this._winkel = _winkel;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Index.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getIndex() {
				return _index;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _index der neue Wert von Index.
			*/
			public void setIndex(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _index) {
				this._index = _index;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getVorschauURI() != null) {
						datum.getTextValue("VorschauURI").setText(getVorschauURI());
					}
					// ZeichenkettenAttributTyp
					if (getBildURI() != null) {
						datum.getTextValue("BildURI").setText(getBildURI());
					}
					// ObjektReferenzAttributTyp
						final Object soStrasse = getStrasse();
						final SystemObject tmpStrasse;
							if (soStrasse instanceof SystemObject) {
								tmpStrasse = (SystemObject)soStrasse;
							} else if(soStrasse instanceof SystemObjekt){
								tmpStrasse = ((SystemObjekt)soStrasse).getSystemObject();
							} else{
								tmpStrasse = null;
							}
						datum.getReferenceValue("Straße").setSystemObject(tmpStrasse);
					// ZeichenkettenAttributTyp
					if (getBlickrichtung() != null) {
						datum.getTextValue("Blickrichtung").setText(getBlickrichtung());
					}
					// ZeichenkettenAttributTyp
					if (getBereich() != null) {
						datum.getTextValue("Bereich").setText(getBereich());
					}
					// GanzzahlAttributTyp
					if (getWinkel() != null) {
		                if (getWinkel().isZustand()) {
		                    datum.getUnscaledValue("Winkel").setText(getWinkel().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Winkel").set(getWinkel().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getIndex() != null) {
		                if (getIndex().isZustand()) {
		                    datum.getUnscaledValue("Index").setText(getIndex().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Index").set(getIndex().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setVorschauURI(daten.getTextValue("VorschauURI").getText());
					// ZeichenkettenAttributTyp
						setBildURI(daten.getTextValue("BildURI").getText());
					// ObjektReferenzAttributTyp
						final long idStrasse = daten.getReferenceValue("Straße").getId();
						final SystemObjekt tmpStrasse;
						if (idStrasse == 0) {
							tmpStrasse = null;
						} else {
							final SystemObject soStrasse = factory.getDav().getDataModel().getObject(idStrasse);
							if (soStrasse == null) {
									tmpStrasse = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrasseUngueltig(idStrasse);
							} else {
								tmpStrasse = factory.getModellobjekt(soStrasse);
							}
						}
						setStrasse((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
						) tmpStrasse);
					// ZeichenkettenAttributTyp
						setBlickrichtung(daten.getTextValue("Blickrichtung").getText());
					// ZeichenkettenAttributTyp
						setBereich(daten.getTextValue("Bereich").getText());
					// GanzzahlAttributTyp
							setWinkel(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Winkel").
									longValue
							()));
					// GanzzahlAttributTyp
							setIndex(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Index").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setVorschauURI(getVorschauURI());
							klon.setBildURI(getBildURI());
							klon.setStrasse(getStrasse());
							klon.setBlickrichtung(getBlickrichtung());
							klon.setBereich(getBereich());
							klon.setWinkel(getWinkel());
							klon.setIndex(getIndex());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.vizKamera";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdVizKamera(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
