/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Langzeitdaten der Datenart Geschwindigkeit [km&#47;h] fuer Leichtverkehr ohne Anhaenger.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdVerkehrsDatenLangZeitGeschwindigkeitsKlassen3FzGruppen extends AbstractOnlineDatensatz<OdVerkehrsDatenLangZeitGeschwindigkeitsKlassen3FzGruppen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.PlausibilitaetsPruefungLogisch,
					Aspekte.MessWertErsetzung,
					Aspekte.PlausibilitaetsPruefungFormal,
					Aspekte.ExterneErfassung,
				};
			}
	
			/**
			 * Attributgruppe nach Modifikation durch die logische Plausibilitätsprüfung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PlausibilitaetsPruefungLogisch = new Aspekte("PlausibilitätsPrüfungLogisch", "asp.plausibilitätsPrüfungLogisch");
			
			/**
			 * Attributgruppe nach Modifikation durch die Messwertersetzung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessWertErsetzung = new Aspekte("MessWertErsetzung", "asp.messWertErsetzung");
			
			/**
			 * Attributgruppe nach Modifikation durch die formale Plausibilitätsprüfung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PlausibilitaetsPruefungFormal = new Aspekte("PlausibilitätsPrüfungFormal", "asp.plausibilitätsPrüfungFormal");
			
			/**
			 * Attributgruppe wurde durch eine externe Erfassungseinheit geschrieben (z.B. TLS).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ExterneErfassung = new Aspekte("ExterneErfassung", "asp.externeErfassung");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qSV
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLVo
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qSGV
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qBPA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 _vmLVo
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 _vmSGV
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 _vmBPA
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 _svmLVo
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 _svmSGV
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 _svmBPA
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v15LVo
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v15SGV
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v15BPA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85LVo
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85SGV
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85BPA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _qLVoGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _qSGVGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(10, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _qBPAGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(10, true);
		
			/**
			Intervalldauer, mit dem die Werte erfasst wurden.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer, mit dem die Werte erfasst wurden.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Verkehrsmenge fuer Lkw, LkwA, Sattel-Kfz und Busse nach TLS 2002.
			<p>
			
			</p>
			
			@return der Wert von QSV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQSV() {
				return _qSV;
			}
		
			/**
			Verkehrsmenge fuer Lkw, LkwA, Sattel-Kfz und Busse nach TLS 2002.
			<p>
			
			</p>
			
			@param _qSV der neue Wert von QSV.
			*/
			public void setQSV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qSV) {
				this._qSV = _qSV;
			}
		
			/**
			Verkehrsmenge fuer Krad, Pkw und Lfw nach TLS 2002.
			<p>
			
			</p>
			
			@return der Wert von QLVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLVo() {
				return _qLVo;
			}
		
			/**
			Verkehrsmenge fuer Krad, Pkw und Lfw nach TLS 2002.
			<p>
			
			</p>
			
			@param _qLVo der neue Wert von QLVo.
			*/
			public void setQLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLVo) {
				this._qLVo = _qLVo;
			}
		
			/**
			Verkehrsmenge fuer Lkw, LkwA und Sattel-Kfz nach TLS 2002.
			<p>
			
			</p>
			
			@return der Wert von QSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQSGV() {
				return _qSGV;
			}
		
			/**
			Verkehrsmenge fuer Lkw, LkwA und Sattel-Kfz nach TLS 2002.
			<p>
			
			</p>
			
			@param _qSGV der neue Wert von QSGV.
			*/
			public void setQSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qSGV) {
				this._qSGV = _qSGV;
			}
		
			/**
			Verkehrsmenge fuer PkwA und Bus nach TLS 2002.
			<p>
			
			</p>
			
			@return der Wert von QBPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQBPA() {
				return _qBPA;
			}
		
			/**
			Verkehrsmenge fuer PkwA und Bus nach TLS 2002.
			<p>
			
			</p>
			
			@param _qBPA der neue Wert von QBPA.
			*/
			public void setQBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qBPA) {
				this._qBPA = _qBPA;
			}
		
			/**
			Mittlere Geschwindigkeit von LVo.
			<p>
			
			</p>
			
			@return der Wert von VmLVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 getVmLVo() {
				return _vmLVo;
			}
		
			/**
			Mittlere Geschwindigkeit von LVo.
			<p>
			
			</p>
			
			@param _vmLVo der neue Wert von VmLVo.
			*/
			public void setVmLVo(de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
			 _vmLVo) {
				this._vmLVo = _vmLVo;
			}
		
			/**
			Mittlere Geschwindigkeit von SGV.
			<p>
			
			</p>
			
			@return der Wert von VmSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 getVmSGV() {
				return _vmSGV;
			}
		
			/**
			Mittlere Geschwindigkeit von SGV.
			<p>
			
			</p>
			
			@param _vmSGV der neue Wert von VmSGV.
			*/
			public void setVmSGV(de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
			 _vmSGV) {
				this._vmSGV = _vmSGV;
			}
		
			/**
			Mittlere Geschwindigkeit von BPA.
			<p>
			
			</p>
			
			@return der Wert von VmBPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 getVmBPA() {
				return _vmBPA;
			}
		
			/**
			Mittlere Geschwindigkeit von BPA.
			<p>
			
			</p>
			
			@param _vmBPA der neue Wert von VmBPA.
			*/
			public void setVmBPA(de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
			 _vmBPA) {
				this._vmBPA = _vmBPA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit von LVo.
			<p>
			
			</p>
			
			@return der Wert von SvmLVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 getSvmLVo() {
				return _svmLVo;
			}
		
			/**
			Standardabweichung der Geschwindigkeit von LVo.
			<p>
			
			</p>
			
			@param _svmLVo der neue Wert von SvmLVo.
			*/
			public void setSvmLVo(de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
			 _svmLVo) {
				this._svmLVo = _svmLVo;
			}
		
			/**
			Standardabweichung der Geschwindigkeit von SGV.
			<p>
			
			</p>
			
			@return der Wert von SvmSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 getSvmSGV() {
				return _svmSGV;
			}
		
			/**
			Standardabweichung der Geschwindigkeit von SGV.
			<p>
			
			</p>
			
			@param _svmSGV der neue Wert von SvmSGV.
			*/
			public void setSvmSGV(de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
			 _svmSGV) {
				this._svmSGV = _svmSGV;
			}
		
			/**
			Standardabweichung der Geschwindigkeit von BPA.
			<p>
			
			</p>
			
			@return der Wert von SvmBPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
				 getSvmBPA() {
				return _svmBPA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit von BPA.
			<p>
			
			</p>
			
			@param _svmBPA der neue Wert von SvmBPA.
			*/
			public void setSvmBPA(de.bsvrz.sys.funclib.bitctrl.modell.bastgeschwindigkeitsdaten.attribute.AtlGeschwindigkeitBASt
			 _svmBPA) {
				this._svmBPA = _svmBPA;
			}
		
			/**
			v15-Geschwindigkeit von LVo.
			<p>
			
			</p>
			
			@return der Wert von V15LVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV15LVo() {
				return _v15LVo;
			}
		
			/**
			v15-Geschwindigkeit von LVo.
			<p>
			
			</p>
			
			@param _v15LVo der neue Wert von V15LVo.
			*/
			public void setV15LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v15LVo) {
				this._v15LVo = _v15LVo;
			}
		
			/**
			v15-Geschwindigkeit von SGV.
			<p>
			
			</p>
			
			@return der Wert von V15SGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV15SGV() {
				return _v15SGV;
			}
		
			/**
			v15-Geschwindigkeit von SGV.
			<p>
			
			</p>
			
			@param _v15SGV der neue Wert von V15SGV.
			*/
			public void setV15SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v15SGV) {
				this._v15SGV = _v15SGV;
			}
		
			/**
			v15-Geschwindigkeit von BPA.
			<p>
			
			</p>
			
			@return der Wert von V15BPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV15BPA() {
				return _v15BPA;
			}
		
			/**
			v15-Geschwindigkeit von BPA.
			<p>
			
			</p>
			
			@param _v15BPA der neue Wert von V15BPA.
			*/
			public void setV15BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v15BPA) {
				this._v15BPA = _v15BPA;
			}
		
			/**
			v85-Geschwindigkeit von LVo.
			<p>
			
			</p>
			
			@return der Wert von V85LVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85LVo() {
				return _v85LVo;
			}
		
			/**
			v85-Geschwindigkeit von LVo.
			<p>
			
			</p>
			
			@param _v85LVo der neue Wert von V85LVo.
			*/
			public void setV85LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85LVo) {
				this._v85LVo = _v85LVo;
			}
		
			/**
			v85-Geschwindigkeit von SGV.
			<p>
			
			</p>
			
			@return der Wert von V85SGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85SGV() {
				return _v85SGV;
			}
		
			/**
			v85-Geschwindigkeit von SGV.
			<p>
			
			</p>
			
			@param _v85SGV der neue Wert von V85SGV.
			*/
			public void setV85SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85SGV) {
				this._v85SGV = _v85SGV;
			}
		
			/**
			v85-Geschwindigkeit von BPA.
			<p>
			
			</p>
			
			@return der Wert von V85BPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85BPA() {
				return _v85BPA;
			}
		
			/**
			v85-Geschwindigkeit von BPA.
			<p>
			
			</p>
			
			@param _v85BPA der neue Wert von V85BPA.
			*/
			public void setV85BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85BPA) {
				this._v85BPA = _v85BPA;
			}
		
			/**
			Anzahl der Fahrzeuge in Geschwindigkeitsklassen LVo.
			<p>
			
			</p>
			
			@return der Wert von QLVoGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getQLVoGeschwKlasse() {
				return _qLVoGeschwKlasse;
			}
		
		
			/**
			Anzahl der Fahrzeuge in Geschwindigkeitsklassen SGV.
			<p>
			
			</p>
			
			@return der Wert von QSGVGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getQSGVGeschwKlasse() {
				return _qSGVGeschwKlasse;
			}
		
		
			/**
			Anzahl der Fahrzeuge in Geschwindigkeitsklassen BPA.
			<p>
			
			</p>
			
			@return der Wert von QBPAGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getQBPAGeschwKlasse() {
				return _qBPAGeschwKlasse;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// AttributListenDefinition
						getQSV().bean2Atl(datum.getItem("qSV"), factory);
					// AttributListenDefinition
						getQLVo().bean2Atl(datum.getItem("qLVo"), factory);
					// AttributListenDefinition
						getQSGV().bean2Atl(datum.getItem("qSGV"), factory);
					// AttributListenDefinition
						getQBPA().bean2Atl(datum.getItem("qBPA"), factory);
					// AttributListenDefinition
						getVmLVo().bean2Atl(datum.getItem("vmLVo"), factory);
					// AttributListenDefinition
						getVmSGV().bean2Atl(datum.getItem("vmSGV"), factory);
					// AttributListenDefinition
						getVmBPA().bean2Atl(datum.getItem("vmBPA"), factory);
					// AttributListenDefinition
						getSvmLVo().bean2Atl(datum.getItem("svmLVo"), factory);
					// AttributListenDefinition
						getSvmSGV().bean2Atl(datum.getItem("svmSGV"), factory);
					// AttributListenDefinition
						getSvmBPA().bean2Atl(datum.getItem("svmBPA"), factory);
					// AttributListenDefinition
						getV15LVo().bean2Atl(datum.getItem("v15LVo"), factory);
					// AttributListenDefinition
						getV15SGV().bean2Atl(datum.getItem("v15SGV"), factory);
					// AttributListenDefinition
						getV15BPA().bean2Atl(datum.getItem("v15BPA"), factory);
					// AttributListenDefinition
						getV85LVo().bean2Atl(datum.getItem("v85LVo"), factory);
					// AttributListenDefinition
						getV85SGV().bean2Atl(datum.getItem("v85SGV"), factory);
					// AttributListenDefinition
						getV85BPA().bean2Atl(datum.getItem("v85BPA"), factory);
					// AttributListenDefinition
						final Data.Array arrayQLVoGeschwKlasse = datum.getArray("qLVoGeschwKlasse");
						arrayQLVoGeschwKlasse.setLength(getQLVoGeschwKlasse().size());
						for (int i = 0; i < arrayQLVoGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getQLVoGeschwKlasse().get(i);
							atl.bean2Atl(arrayQLVoGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQSGVGeschwKlasse = datum.getArray("qSGVGeschwKlasse");
						arrayQSGVGeschwKlasse.setLength(getQSGVGeschwKlasse().size());
						for (int i = 0; i < arrayQSGVGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getQSGVGeschwKlasse().get(i);
							atl.bean2Atl(arrayQSGVGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQBPAGeschwKlasse = datum.getArray("qBPAGeschwKlasse");
						arrayQBPAGeschwKlasse.setLength(getQBPAGeschwKlasse().size());
						for (int i = 0; i < arrayQBPAGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getQBPAGeschwKlasse().get(i);
							atl.bean2Atl(arrayQBPAGeschwKlasse.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// AttributListenDefinition
						getQSV().atl2Bean(daten.getItem("qSV"), factory);
					// AttributListenDefinition
						getQLVo().atl2Bean(daten.getItem("qLVo"), factory);
					// AttributListenDefinition
						getQSGV().atl2Bean(daten.getItem("qSGV"), factory);
					// AttributListenDefinition
						getQBPA().atl2Bean(daten.getItem("qBPA"), factory);
					// AttributListenDefinition
						getVmLVo().atl2Bean(daten.getItem("vmLVo"), factory);
					// AttributListenDefinition
						getVmSGV().atl2Bean(daten.getItem("vmSGV"), factory);
					// AttributListenDefinition
						getVmBPA().atl2Bean(daten.getItem("vmBPA"), factory);
					// AttributListenDefinition
						getSvmLVo().atl2Bean(daten.getItem("svmLVo"), factory);
					// AttributListenDefinition
						getSvmSGV().atl2Bean(daten.getItem("svmSGV"), factory);
					// AttributListenDefinition
						getSvmBPA().atl2Bean(daten.getItem("svmBPA"), factory);
					// AttributListenDefinition
						getV15LVo().atl2Bean(daten.getItem("v15LVo"), factory);
					// AttributListenDefinition
						getV15SGV().atl2Bean(daten.getItem("v15SGV"), factory);
					// AttributListenDefinition
						getV15BPA().atl2Bean(daten.getItem("v15BPA"), factory);
					// AttributListenDefinition
						getV85LVo().atl2Bean(daten.getItem("v85LVo"), factory);
					// AttributListenDefinition
						getV85SGV().atl2Bean(daten.getItem("v85SGV"), factory);
					// AttributListenDefinition
						getV85BPA().atl2Bean(daten.getItem("v85BPA"), factory);
					// AttributListenDefinition
						final Data.Array arrayQLVoGeschwKlasse = daten.getArray("qLVoGeschwKlasse");
						for (int i = 0; i < arrayQLVoGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayQLVoGeschwKlasse.getItem(i), factory);
							getQLVoGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQSGVGeschwKlasse = daten.getArray("qSGVGeschwKlasse");
						for (int i = 0; i < arrayQSGVGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayQSGVGeschwKlasse.getItem(i), factory);
							getQSGVGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQBPAGeschwKlasse = daten.getArray("qBPAGeschwKlasse");
						for (int i = 0; i < arrayQBPAGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayQBPAGeschwKlasse.getItem(i), factory);
							getQBPAGeschwKlasse().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon._qSV = getQSV().clone();
							klon._qLVo = getQLVo().clone();
							klon._qSGV = getQSGV().clone();
							klon._qBPA = getQBPA().clone();
							klon._vmLVo = getVmLVo().clone();
							klon._vmSGV = getVmSGV().clone();
							klon._vmBPA = getVmBPA().clone();
							klon._svmLVo = getSvmLVo().clone();
							klon._svmSGV = getSvmSGV().clone();
							klon._svmBPA = getSvmBPA().clone();
							klon._v15LVo = getV15LVo().clone();
							klon._v15SGV = getV15SGV().clone();
							klon._v15BPA = getV15BPA().clone();
							klon._v85LVo = getV85LVo().clone();
							klon._v85SGV = getV85SGV().clone();
							klon._v85BPA = getV85BPA().clone();
						klon._qLVoGeschwKlasse = getQLVoGeschwKlasse().clone();
						klon._qSGVGeschwKlasse = getQSGVGeschwKlasse().clone();
						klon._qBPAGeschwKlasse = getQBPAGeschwKlasse().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenLangZeitGeschwindigkeitsKlassen3FzGruppen";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenLangZeitGeschwindigkeitsKlassen3FzGruppen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
