/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekt zur Beschreibung einer BASt-Datenquelle unter einem
					bestimmten BASt-Format.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface BastDatenObjektMultiFormat extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.objekte.BastDatenObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.bastDatenObjektMultiFormat"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Fahrstreifen, die die Bast-Daten liefern.
<p>

</p>

@return die Menge BastFahrStreifen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.objekte.BastFahrStreifen> getBastFahrStreifen();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	BASt-Daten-Format.
	<p>
	
	</p>
	@return der Datensatz BastFormat.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.konfigurationsdaten.KdBastFormat getKdBastFormat();
	
	/**
	Bast-Daten: Termin an dem eine Bast-Datei erstellt wurde.
	<p>
	
	</p>
	@return der Datensatz BastDatenErstellt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.onlinedaten.OdBastDatenErstellt getOdBastDatenErstellt();
	
	/**
	Parameter für BASt-Info-Daten.
	<p>
	
	</p>
	@return der Datensatz BastInfoDateiParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdBastInfoDateiParameter getPdBastInfoDateiParameter();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Die Version einer BASt-Station ist Anzahl, wie oft die
						Station im laufenden Jahr bereits ihr BASt-Format
						gewechselt hat
						(auch durch Aenderung der Anzahl der Fahrstreifen).
	<p>
	
	</p>
	@return der Datensatz BastStationsVersion.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.konfigurationsdaten.KdBastStationsVersion getKdBastStationsVersion();
	
	/**
	Bast-Daten: Termin an dem eine Bast-Datei an die BASt
						versendet wurde.
	<p>
	
	</p>
	@return der Datensatz BastDatenBastVersendet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.onlinedaten.OdBastDatenBastVersendet getOdBastDatenBastVersendet();
	
	/**
	Parameter für BAST-Daten.
	<p>
	
	</p>
	@return der Datensatz BastDatenParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdBastDatenParameter getPdBastDatenParameter();
	
	/**
	Bast-Daten: Objekt für das ein Bast(band)erstellt wird.
	<p>
	
	</p>
	@return der Datensatz BastDatenObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.konfigurationsdaten.KdBastDatenObjekt getKdBastDatenObjekt();
	
	/**
	Bast-Daten: Termin an dem eine Bast-Datei reimportiert
						wurde.
	<p>
	
	</p>
	@return der Datensatz BastDatenReimportiert.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.onlinedaten.OdBastDatenReimportiert getOdBastDatenReimportiert();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Bast-Daten: Termin an dem eine Bast-Datei versendet wurde.
	<p>
	
	</p>
	@return der Datensatz BastDatenVersendet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.onlinedaten.OdBastDatenVersendet getOdBastDatenVersendet();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
