/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter zur Vermailung von Bastdateien.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdBcBastDateiCommand extends AbstractOnlineDatensatz<OdBcBastDateiCommand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.BcBastServerRequest,
					Aspekte.BcBastServerResponse,
				};
			}
	
			/**
			 * Kommando an die Kalenderverwaltung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt BcBastServerRequest = new Aspekte("BastKommando", "asp.bcBastServerRequest");
			
			/**
			 * Response auf Kommando vom Systemkalender.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt BcBastServerResponse = new Aspekte("Ergebnis", "asp.bcBastServerResponse");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _applicationId
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _requestId
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _status
				;
				private String
				 _message
				= new String
				()
				;
				private String
				 _bastNummer
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _monat
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _jahr
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ueberschreiben
				;
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von ApplicationId.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getApplicationId() {
				return _applicationId;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _applicationId der neue Wert von ApplicationId.
			*/
			public void setApplicationId(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _applicationId) {
				this._applicationId = _applicationId;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von RequestId.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getRequestId() {
				return _requestId;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _requestId der neue Wert von RequestId.
			*/
			public void setRequestId(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _requestId) {
				this._requestId = _requestId;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getStatus() {
				return _status;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _status) {
				this._status = _status;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Message.
			*/
				public String
				 getMessage() {
				return _message;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _message der neue Wert von Message.
			*/
			public void setMessage(String
			 _message) {
				if (_message.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._message = _message;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von BastNummer.
			*/
				public String
				 getBastNummer() {
				return _bastNummer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bastNummer der neue Wert von BastNummer.
			*/
			public void setBastNummer(String
			 _bastNummer) {
				if (_bastNummer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bastNummer = _bastNummer;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Monat.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMonat() {
				return _monat;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _monat der neue Wert von Monat.
			*/
			public void setMonat(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _monat) {
				this._monat = _monat;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Jahr.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getJahr() {
				return _jahr;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _jahr der neue Wert von Jahr.
			*/
			public void setJahr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _jahr) {
				this._jahr = _jahr;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Ueberschreiben.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getUeberschreiben() {
				return _ueberschreiben;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _ueberschreiben der neue Wert von Ueberschreiben.
			*/
			public void setUeberschreiben(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ueberschreiben) {
				this._ueberschreiben = _ueberschreiben;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getApplicationId() != null) {
		                if (getApplicationId().isZustand()) {
		                    datum.getUnscaledValue("ApplicationId").setText(getApplicationId().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ApplicationId").set(getApplicationId().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRequestId() != null) {
		                if (getRequestId().isZustand()) {
		                    datum.getUnscaledValue("RequestId").setText(getRequestId().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RequestId").set(getRequestId().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("Status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Status").set(getStatus().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getMessage() != null) {
						datum.getTextValue("Message").setText(getMessage());
					}
					// ZeichenkettenAttributTyp
					if (getBastNummer() != null) {
						datum.getTextValue("BastNummer").setText(getBastNummer());
					}
					// GanzzahlAttributTyp
					if (getMonat() != null) {
		                if (getMonat().isZustand()) {
		                    datum.getUnscaledValue("Monat").setText(getMonat().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Monat").set(getMonat().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getJahr() != null) {
		                if (getJahr().isZustand()) {
		                    datum.getUnscaledValue("Jahr").setText(getJahr().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Jahr").set(getJahr().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getUeberschreiben() != null) {
		                if (getUeberschreiben().isZustand()) {
		                    datum.getUnscaledValue("Überschreiben").setText(getUeberschreiben().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Überschreiben").set(getUeberschreiben().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setApplicationId(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("ApplicationId").
									longValue
							()));
					// GanzzahlAttributTyp
							setRequestId(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("RequestId").
									longValue
							()));
					// GanzzahlAttributTyp
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Status").
									longValue
							()));
					// ZeichenkettenAttributTyp
						setMessage(daten.getTextValue("Message").getText());
					// ZeichenkettenAttributTyp
						setBastNummer(daten.getTextValue("BastNummer").getText());
					// GanzzahlAttributTyp
							setMonat(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Monat").
									longValue
							()));
					// GanzzahlAttributTyp
							setJahr(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Jahr").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Überschreiben").isState()) {
								setUeberschreiben(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Überschreiben").getText()));
							} else {
							setUeberschreiben(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Überschreiben").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setApplicationId(getApplicationId());
							klon.setRequestId(getRequestId());
							klon.setStatus(getStatus());
							klon.setMessage(getMessage());
							klon.setBastNummer(getBastNummer());
							klon.setMonat(getMonat());
							klon.setJahr(getJahr());
							klon.setUeberschreiben(getUeberschreiben());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bcBastDateiCommand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBcBastDateiCommand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
