/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter zur automatischen Bastdatei-Erstellung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdBastAutomation extends AbstractParameterDatensatz<PdBastAutomation.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _intervall
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _erstellen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _nachWarnung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _nachWarnIntervall
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _nachVersand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _bastVersand
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Intervall.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getIntervall() {
				return _intervall;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _intervall der neue Wert von Intervall.
			*/
			public void setIntervall(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _intervall) {
				this._intervall = _intervall;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Erstellen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getErstellen() {
				return _erstellen;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _erstellen der neue Wert von Erstellen.
			*/
			public void setErstellen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _erstellen) {
				this._erstellen = _erstellen;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von NachWarnung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getNachWarnung() {
				return _nachWarnung;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _nachWarnung der neue Wert von NachWarnung.
			*/
			public void setNachWarnung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _nachWarnung) {
				this._nachWarnung = _nachWarnung;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von NachWarnIntervall.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getNachWarnIntervall() {
				return _nachWarnIntervall;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _nachWarnIntervall der neue Wert von NachWarnIntervall.
			*/
			public void setNachWarnIntervall(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _nachWarnIntervall) {
				this._nachWarnIntervall = _nachWarnIntervall;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von NachVersand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getNachVersand() {
				return _nachVersand;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _nachVersand der neue Wert von NachVersand.
			*/
			public void setNachVersand(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _nachVersand) {
				this._nachVersand = _nachVersand;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von BastVersand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getBastVersand() {
				return _bastVersand;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _bastVersand der neue Wert von BastVersand.
			*/
			public void setBastVersand(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _bastVersand) {
				this._bastVersand = _bastVersand;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getIntervall() != null) {
		                if (getIntervall().isZustand()) {
		                    datum.getUnscaledValue("Intervall").setText(getIntervall().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Intervall").set(getIntervall().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getErstellen() != null) {
		                if (getErstellen().isZustand()) {
		                    datum.getUnscaledValue("Erstellen").setText(getErstellen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Erstellen").set(getErstellen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNachWarnung() != null) {
		                if (getNachWarnung().isZustand()) {
		                    datum.getUnscaledValue("NachWarnung").setText(getNachWarnung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("NachWarnung").set(getNachWarnung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNachWarnIntervall() != null) {
		                if (getNachWarnIntervall().isZustand()) {
		                    datum.getUnscaledValue("NachWarnIntervall").setText(getNachWarnIntervall().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("NachWarnIntervall").set(getNachWarnIntervall().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNachVersand() != null) {
		                if (getNachVersand().isZustand()) {
		                    datum.getUnscaledValue("NachVersand").setText(getNachVersand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("NachVersand").set(getNachVersand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBastVersand() != null) {
		                if (getBastVersand().isZustand()) {
		                    datum.getUnscaledValue("BastVersand").setText(getBastVersand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BastVersand").set(getBastVersand().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							setIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Intervall").
									longValue
							()));
					// GanzzahlAttributTyp
							setErstellen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Erstellen").
									longValue
							()));
					// GanzzahlAttributTyp
							setNachWarnung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("NachWarnung").
									longValue
							()));
					// GanzzahlAttributTyp
							setNachWarnIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("NachWarnIntervall").
									longValue
							()));
					// GanzzahlAttributTyp
							setNachVersand(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("NachVersand").
									longValue
							()));
					// GanzzahlAttributTyp
							setBastVersand(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("BastVersand").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setIntervall(getIntervall());
							klon.setErstellen(getErstellen());
							klon.setNachWarnung(getNachWarnung());
							klon.setNachWarnIntervall(getNachWarnIntervall());
							klon.setNachVersand(getNachVersand());
							klon.setBastVersand(getBastVersand());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bastAutomation";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdBastAutomation(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
