/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für BASt-Info-Daten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdBastInfoDateiParameter extends AbstractParameterDatensatz<PdBastInfoDateiParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _dateiErzeugen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _dateiVersenden
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _standardMeldungenProtokollieren
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _infoMeldungenProtokollieren
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _warnungMeldungenProtokollieren
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _fehlerMeldungenProtokollieren
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _sMBetriebsmeldungen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _eAKBetriebsmeldungen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _lVEDEBetriebsmeldungen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _fSBetriebsmeldungen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _baustellenzustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _lZDAbrufProtokoll
				;
				private Feld<String
				> _schwarzliste = new Feld<String
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von DateiErzeugen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getDateiErzeugen() {
				return _dateiErzeugen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _dateiErzeugen der neue Wert von DateiErzeugen.
			*/
			public void setDateiErzeugen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _dateiErzeugen) {
				this._dateiErzeugen = _dateiErzeugen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von DateiVersenden.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getDateiVersenden() {
				return _dateiVersenden;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _dateiVersenden der neue Wert von DateiVersenden.
			*/
			public void setDateiVersenden(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _dateiVersenden) {
				this._dateiVersenden = _dateiVersenden;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von StandardMeldungenProtokollieren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getStandardMeldungenProtokollieren() {
				return _standardMeldungenProtokollieren;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _standardMeldungenProtokollieren der neue Wert von StandardMeldungenProtokollieren.
			*/
			public void setStandardMeldungenProtokollieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _standardMeldungenProtokollieren) {
				this._standardMeldungenProtokollieren = _standardMeldungenProtokollieren;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von InfoMeldungenProtokollieren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getInfoMeldungenProtokollieren() {
				return _infoMeldungenProtokollieren;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _infoMeldungenProtokollieren der neue Wert von InfoMeldungenProtokollieren.
			*/
			public void setInfoMeldungenProtokollieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _infoMeldungenProtokollieren) {
				this._infoMeldungenProtokollieren = _infoMeldungenProtokollieren;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von WarnungMeldungenProtokollieren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getWarnungMeldungenProtokollieren() {
				return _warnungMeldungenProtokollieren;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _warnungMeldungenProtokollieren der neue Wert von WarnungMeldungenProtokollieren.
			*/
			public void setWarnungMeldungenProtokollieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _warnungMeldungenProtokollieren) {
				this._warnungMeldungenProtokollieren = _warnungMeldungenProtokollieren;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von FehlerMeldungenProtokollieren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getFehlerMeldungenProtokollieren() {
				return _fehlerMeldungenProtokollieren;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _fehlerMeldungenProtokollieren der neue Wert von FehlerMeldungenProtokollieren.
			*/
			public void setFehlerMeldungenProtokollieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _fehlerMeldungenProtokollieren) {
				this._fehlerMeldungenProtokollieren = _fehlerMeldungenProtokollieren;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von SMBetriebsmeldungen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSMBetriebsmeldungen() {
				return _sMBetriebsmeldungen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _sMBetriebsmeldungen der neue Wert von SMBetriebsmeldungen.
			*/
			public void setSMBetriebsmeldungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _sMBetriebsmeldungen) {
				this._sMBetriebsmeldungen = _sMBetriebsmeldungen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von EAKBetriebsmeldungen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEAKBetriebsmeldungen() {
				return _eAKBetriebsmeldungen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _eAKBetriebsmeldungen der neue Wert von EAKBetriebsmeldungen.
			*/
			public void setEAKBetriebsmeldungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _eAKBetriebsmeldungen) {
				this._eAKBetriebsmeldungen = _eAKBetriebsmeldungen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von LVEDEBetriebsmeldungen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getLVEDEBetriebsmeldungen() {
				return _lVEDEBetriebsmeldungen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _lVEDEBetriebsmeldungen der neue Wert von LVEDEBetriebsmeldungen.
			*/
			public void setLVEDEBetriebsmeldungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _lVEDEBetriebsmeldungen) {
				this._lVEDEBetriebsmeldungen = _lVEDEBetriebsmeldungen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von FSBetriebsmeldungen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getFSBetriebsmeldungen() {
				return _fSBetriebsmeldungen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _fSBetriebsmeldungen der neue Wert von FSBetriebsmeldungen.
			*/
			public void setFSBetriebsmeldungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _fSBetriebsmeldungen) {
				this._fSBetriebsmeldungen = _fSBetriebsmeldungen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Baustellenzustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getBaustellenzustand() {
				return _baustellenzustand;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _baustellenzustand der neue Wert von Baustellenzustand.
			*/
			public void setBaustellenzustand(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _baustellenzustand) {
				this._baustellenzustand = _baustellenzustand;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von LZDAbrufProtokoll.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getLZDAbrufProtokoll() {
				return _lZDAbrufProtokoll;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _lZDAbrufProtokoll der neue Wert von LZDAbrufProtokoll.
			*/
			public void setLZDAbrufProtokoll(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _lZDAbrufProtokoll) {
				this._lZDAbrufProtokoll = _lZDAbrufProtokoll;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Schwarzliste.
			*/
				public Feld<String
				> getSchwarzliste() {
				return _schwarzliste;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getDateiErzeugen() != null) {
		                if (getDateiErzeugen().isZustand()) {
		                    datum.getUnscaledValue("DateiErzeugen").setText(getDateiErzeugen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DateiErzeugen").set(getDateiErzeugen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDateiVersenden() != null) {
		                if (getDateiVersenden().isZustand()) {
		                    datum.getUnscaledValue("DateiVersenden").setText(getDateiVersenden().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DateiVersenden").set(getDateiVersenden().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStandardMeldungenProtokollieren() != null) {
		                if (getStandardMeldungenProtokollieren().isZustand()) {
		                    datum.getUnscaledValue("StandardMeldungenProtokollieren").setText(getStandardMeldungenProtokollieren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StandardMeldungenProtokollieren").set(getStandardMeldungenProtokollieren().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getInfoMeldungenProtokollieren() != null) {
		                if (getInfoMeldungenProtokollieren().isZustand()) {
		                    datum.getUnscaledValue("InfoMeldungenProtokollieren").setText(getInfoMeldungenProtokollieren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("InfoMeldungenProtokollieren").set(getInfoMeldungenProtokollieren().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getWarnungMeldungenProtokollieren() != null) {
		                if (getWarnungMeldungenProtokollieren().isZustand()) {
		                    datum.getUnscaledValue("WarnungMeldungenProtokollieren").setText(getWarnungMeldungenProtokollieren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("WarnungMeldungenProtokollieren").set(getWarnungMeldungenProtokollieren().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFehlerMeldungenProtokollieren() != null) {
		                if (getFehlerMeldungenProtokollieren().isZustand()) {
		                    datum.getUnscaledValue("FehlerMeldungenProtokollieren").setText(getFehlerMeldungenProtokollieren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FehlerMeldungenProtokollieren").set(getFehlerMeldungenProtokollieren().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSMBetriebsmeldungen() != null) {
		                if (getSMBetriebsmeldungen().isZustand()) {
		                    datum.getUnscaledValue("SMBetriebsmeldungen").setText(getSMBetriebsmeldungen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SMBetriebsmeldungen").set(getSMBetriebsmeldungen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEAKBetriebsmeldungen() != null) {
		                if (getEAKBetriebsmeldungen().isZustand()) {
		                    datum.getUnscaledValue("EAKBetriebsmeldungen").setText(getEAKBetriebsmeldungen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EAKBetriebsmeldungen").set(getEAKBetriebsmeldungen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLVEDEBetriebsmeldungen() != null) {
		                if (getLVEDEBetriebsmeldungen().isZustand()) {
		                    datum.getUnscaledValue("LVEDEBetriebsmeldungen").setText(getLVEDEBetriebsmeldungen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LVEDEBetriebsmeldungen").set(getLVEDEBetriebsmeldungen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFSBetriebsmeldungen() != null) {
		                if (getFSBetriebsmeldungen().isZustand()) {
		                    datum.getUnscaledValue("FSBetriebsmeldungen").setText(getFSBetriebsmeldungen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FSBetriebsmeldungen").set(getFSBetriebsmeldungen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBaustellenzustand() != null) {
		                if (getBaustellenzustand().isZustand()) {
		                    datum.getUnscaledValue("Baustellenzustand").setText(getBaustellenzustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Baustellenzustand").set(getBaustellenzustand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLZDAbrufProtokoll() != null) {
		                if (getLZDAbrufProtokoll().isZustand()) {
		                    datum.getUnscaledValue("LZDAbrufProtokoll").setText(getLZDAbrufProtokoll().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LZDAbrufProtokoll").set(getLZDAbrufProtokoll().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getSchwarzliste() != null) {
						final Data.TextArray arraySchwarzliste = datum.getTextArray("Schwarzliste");
						arraySchwarzliste.setLength(getSchwarzliste().size());
						for (int i = 0; i < arraySchwarzliste.getLength(); ++i) {
							arraySchwarzliste.getTextValue(i).setText(getSchwarzliste().get(i));
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DateiErzeugen").isState()) {
								setDateiErzeugen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("DateiErzeugen").getText()));
							} else {
							setDateiErzeugen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("DateiErzeugen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DateiVersenden").isState()) {
								setDateiVersenden(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("DateiVersenden").getText()));
							} else {
							setDateiVersenden(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("DateiVersenden").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StandardMeldungenProtokollieren").isState()) {
								setStandardMeldungenProtokollieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("StandardMeldungenProtokollieren").getText()));
							} else {
							setStandardMeldungenProtokollieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("StandardMeldungenProtokollieren").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("InfoMeldungenProtokollieren").isState()) {
								setInfoMeldungenProtokollieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("InfoMeldungenProtokollieren").getText()));
							} else {
							setInfoMeldungenProtokollieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("InfoMeldungenProtokollieren").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("WarnungMeldungenProtokollieren").isState()) {
								setWarnungMeldungenProtokollieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("WarnungMeldungenProtokollieren").getText()));
							} else {
							setWarnungMeldungenProtokollieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("WarnungMeldungenProtokollieren").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FehlerMeldungenProtokollieren").isState()) {
								setFehlerMeldungenProtokollieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("FehlerMeldungenProtokollieren").getText()));
							} else {
							setFehlerMeldungenProtokollieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("FehlerMeldungenProtokollieren").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SMBetriebsmeldungen").isState()) {
								setSMBetriebsmeldungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("SMBetriebsmeldungen").getText()));
							} else {
							setSMBetriebsmeldungen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("SMBetriebsmeldungen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EAKBetriebsmeldungen").isState()) {
								setEAKBetriebsmeldungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EAKBetriebsmeldungen").getText()));
							} else {
							setEAKBetriebsmeldungen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EAKBetriebsmeldungen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LVEDEBetriebsmeldungen").isState()) {
								setLVEDEBetriebsmeldungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("LVEDEBetriebsmeldungen").getText()));
							} else {
							setLVEDEBetriebsmeldungen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("LVEDEBetriebsmeldungen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FSBetriebsmeldungen").isState()) {
								setFSBetriebsmeldungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("FSBetriebsmeldungen").getText()));
							} else {
							setFSBetriebsmeldungen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("FSBetriebsmeldungen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Baustellenzustand").isState()) {
								setBaustellenzustand(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Baustellenzustand").getText()));
							} else {
							setBaustellenzustand(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Baustellenzustand").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LZDAbrufProtokoll").isState()) {
								setLZDAbrufProtokoll(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("LZDAbrufProtokoll").getText()));
							} else {
							setLZDAbrufProtokoll(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("LZDAbrufProtokoll").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						final Data.TextArray arraySchwarzliste = daten.getTextArray("Schwarzliste");
						for (int i = 0; i < arraySchwarzliste.getLength(); ++i) {
							getSchwarzliste().add(arraySchwarzliste.getText(i));
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setDateiErzeugen(getDateiErzeugen());
							klon.setDateiVersenden(getDateiVersenden());
							klon.setStandardMeldungenProtokollieren(getStandardMeldungenProtokollieren());
							klon.setInfoMeldungenProtokollieren(getInfoMeldungenProtokollieren());
							klon.setWarnungMeldungenProtokollieren(getWarnungMeldungenProtokollieren());
							klon.setFehlerMeldungenProtokollieren(getFehlerMeldungenProtokollieren());
							klon.setSMBetriebsmeldungen(getSMBetriebsmeldungen());
							klon.setEAKBetriebsmeldungen(getEAKBetriebsmeldungen());
							klon.setLVEDEBetriebsmeldungen(getLVEDEBetriebsmeldungen());
							klon.setFSBetriebsmeldungen(getFSBetriebsmeldungen());
							klon.setBaustellenzustand(getBaustellenzustand());
							klon.setLZDAbrufProtokoll(getLZDAbrufProtokoll());
						klon._schwarzliste = getSchwarzliste().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bastInfoDateiParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdBastInfoDateiParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
