/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter zur Versendung von E-Mail.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class PdMailVersandParameter extends AbstractParameterDatensatz<PdMailVersandParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _inputServer
				= new String
				()
				;
				private String
				 _inputUser
				= new String
				()
				;
				private String
				 _inputPass
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _inputAuthReq
				;
				private String
				 _outputServer
				= new String
				()
				;
				private String
				 _outputUser
				= new String
				()
				;
				private String
				 _outputPass
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _outputAuthReq
				;
				private String
				 _senderAdress
				= new String
				()
				;
				private Feld<String
				> _errorReceiver = new Feld<String
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von InputServer.
			*/
				public String
				 getInputServer() {
				return _inputServer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _inputServer der neue Wert von InputServer.
			*/
			public void setInputServer(String
			 _inputServer) {
				if (_inputServer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._inputServer = _inputServer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von InputUser.
			*/
				public String
				 getInputUser() {
				return _inputUser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _inputUser der neue Wert von InputUser.
			*/
			public void setInputUser(String
			 _inputUser) {
				if (_inputUser.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._inputUser = _inputUser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von InputPass.
			*/
				public String
				 getInputPass() {
				return _inputPass;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _inputPass der neue Wert von InputPass.
			*/
			public void setInputPass(String
			 _inputPass) {
				if (_inputPass.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._inputPass = _inputPass;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von InputAuthReq.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getInputAuthReq() {
				return _inputAuthReq;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _inputAuthReq der neue Wert von InputAuthReq.
			*/
			public void setInputAuthReq(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _inputAuthReq) {
				this._inputAuthReq = _inputAuthReq;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von OutputServer.
			*/
				public String
				 getOutputServer() {
				return _outputServer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _outputServer der neue Wert von OutputServer.
			*/
			public void setOutputServer(String
			 _outputServer) {
				if (_outputServer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._outputServer = _outputServer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von OutputUser.
			*/
				public String
				 getOutputUser() {
				return _outputUser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _outputUser der neue Wert von OutputUser.
			*/
			public void setOutputUser(String
			 _outputUser) {
				if (_outputUser.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._outputUser = _outputUser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von OutputPass.
			*/
				public String
				 getOutputPass() {
				return _outputPass;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _outputPass der neue Wert von OutputPass.
			*/
			public void setOutputPass(String
			 _outputPass) {
				if (_outputPass.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._outputPass = _outputPass;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von OutputAuthReq.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getOutputAuthReq() {
				return _outputAuthReq;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _outputAuthReq der neue Wert von OutputAuthReq.
			*/
			public void setOutputAuthReq(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _outputAuthReq) {
				this._outputAuthReq = _outputAuthReq;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von SenderAdress.
			*/
				public String
				 getSenderAdress() {
				return _senderAdress;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _senderAdress der neue Wert von SenderAdress.
			*/
			public void setSenderAdress(String
			 _senderAdress) {
				if (_senderAdress.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._senderAdress = _senderAdress;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von ErrorReceiver.
			*/
				public Feld<String
				> getErrorReceiver() {
				return _errorReceiver;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getInputServer() != null) {
						datum.getTextValue("InputServer").setText(getInputServer());
					}
					// ZeichenkettenAttributTyp
					if (getInputUser() != null) {
						datum.getTextValue("InputUser").setText(getInputUser());
					}
					// ZeichenkettenAttributTyp
					if (getInputPass() != null) {
						datum.getTextValue("InputPass").setText(getInputPass());
					}
					// GanzzahlAttributTyp
					if (getInputAuthReq() != null) {
		                if (getInputAuthReq().isZustand()) {
		                    datum.getUnscaledValue("InputAuthReq").setText(getInputAuthReq().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("InputAuthReq").set(getInputAuthReq().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getOutputServer() != null) {
						datum.getTextValue("OutputServer").setText(getOutputServer());
					}
					// ZeichenkettenAttributTyp
					if (getOutputUser() != null) {
						datum.getTextValue("OutputUser").setText(getOutputUser());
					}
					// ZeichenkettenAttributTyp
					if (getOutputPass() != null) {
						datum.getTextValue("OutputPass").setText(getOutputPass());
					}
					// GanzzahlAttributTyp
					if (getOutputAuthReq() != null) {
		                if (getOutputAuthReq().isZustand()) {
		                    datum.getUnscaledValue("OutputAuthReq").setText(getOutputAuthReq().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("OutputAuthReq").set(getOutputAuthReq().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getSenderAdress() != null) {
						datum.getTextValue("SenderAdress").setText(getSenderAdress());
					}
					// ZeichenkettenAttributTyp
					if (getErrorReceiver() != null) {
						final Data.TextArray arrayErrorReceiver = datum.getTextArray("ErrorReceiver");
						arrayErrorReceiver.setLength(getErrorReceiver().size());
						for (int i = 0; i < arrayErrorReceiver.getLength(); ++i) {
							arrayErrorReceiver.getTextValue(i).setText(getErrorReceiver().get(i));
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setInputServer(daten.getTextValue("InputServer").getText());
					// ZeichenkettenAttributTyp
						setInputUser(daten.getTextValue("InputUser").getText());
					// ZeichenkettenAttributTyp
						setInputPass(daten.getTextValue("InputPass").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("InputAuthReq").isState()) {
								setInputAuthReq(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("InputAuthReq").getText()));
							} else {
							setInputAuthReq(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("InputAuthReq").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setOutputServer(daten.getTextValue("OutputServer").getText());
					// ZeichenkettenAttributTyp
						setOutputUser(daten.getTextValue("OutputUser").getText());
					// ZeichenkettenAttributTyp
						setOutputPass(daten.getTextValue("OutputPass").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("OutputAuthReq").isState()) {
								setOutputAuthReq(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("OutputAuthReq").getText()));
							} else {
							setOutputAuthReq(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("OutputAuthReq").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setSenderAdress(daten.getTextValue("SenderAdress").getText());
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayErrorReceiver = daten.getTextArray("ErrorReceiver");
						for (int i = 0; i < arrayErrorReceiver.getLength(); ++i) {
							getErrorReceiver().add(arrayErrorReceiver.getText(i));
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setInputServer(getInputServer());
							klon.setInputUser(getInputUser());
							klon.setInputPass(getInputPass());
							klon.setInputAuthReq(getInputAuthReq());
							klon.setOutputServer(getOutputServer());
							klon.setOutputUser(getOutputUser());
							klon.setOutputPass(getOutputPass());
							klon.setOutputAuthReq(getOutputAuthReq());
							klon.setSenderAdress(getSenderAdress());
						klon._errorReceiver = getErrorReceiver().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.mailVersandParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdMailVersandParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
