/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Allgemeiner Parameter aus einer Name-Wert-Kombination.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlBcDataItem implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private String
			 _value
			= new String
			()
			;
	
		/**
		Bezeichner.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Bezeichner.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Wert als String.
		<p>
		
		</p>
		
		@return der Wert von Value.
		*/
			public String
			 getValue() {
			return _value;
		}
	
		/**
		Wert als String.
		<p>
		
		</p>
		
		@param _value der neue Wert von Value.
		*/
		public void setValue(String
		 _value) {
			if (_value.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._value = _value;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ZeichenkettenAttributTyp
				if (getValue() != null) {
					datum.getTextValue("Value").setText(getValue());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ZeichenkettenAttributTyp
					setValue(daten.getTextValue("Value").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcDataItem clone() {
		AtlBcDataItem klon = new AtlBcDataItem();
		
						klon.setName(getName());
						klon.setValue(getValue());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
