/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein Intervall zweier ganzer Zahlen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlIntervall implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
			 _start
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
			 _ende
			;
	
		/**
		Eine Intervallgrenze, also Minimum oder Maximum.
		<p>
		
		</p>
		
		@return der Wert von Start.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
			 getStart() {
			return _start;
		}
	
		/**
		Eine Intervallgrenze, also Minimum oder Maximum.
		<p>
		
		</p>
		
		@param _start der neue Wert von Start.
		*/
		public void setStart(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
		 _start) {
			this._start = _start;
		}
	
		/**
		Eine Intervallgrenze, also Minimum oder Maximum.
		<p>
		
		</p>
		
		@return der Wert von Ende.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
			 getEnde() {
			return _ende;
		}
	
		/**
		Eine Intervallgrenze, also Minimum oder Maximum.
		<p>
		
		</p>
		
		@param _ende der neue Wert von Ende.
		*/
		public void setEnde(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
		 _ende) {
			this._ende = _ende;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getStart() != null) {
	                if (getStart().isZustand()) {
	                    datum.getUnscaledValue("Start").setText(getStart().toString());
	                } else {
						datum.
						getScaledValue
	                	("Start").set(getStart().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEnde() != null) {
	                if (getEnde().isZustand()) {
	                    datum.getUnscaledValue("Ende").setText(getEnde().toString());
	                } else {
						datum.
						getScaledValue
	                	("Ende").set(getEnde().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Start").isState()) {
							setStart(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
							.getZustand(daten.getScaledValue("Start").getText()));
						} else {
						setStart(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
						(daten.
							getScaledValue
						("Start").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Ende").isState()) {
							setEnde(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
							.getZustand(daten.getScaledValue("Ende").getText()));
						} else {
						setEnde(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttIntervallGrenze
						(daten.
							getScaledValue
						("Ende").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlIntervall clone() {
		AtlIntervall klon = new AtlIntervall();
		
						klon.setStart(getStart());
						klon.setEnde(getEnde());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
