/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt einen Punkt mit x- und y-Koordinate.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlPunkt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _x
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _y
			;
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von X.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getX() {
			return _x;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _x der neue Wert von X.
		*/
		public void setX(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _x) {
			this._x = _x;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von Y.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getY() {
			return _y;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _y der neue Wert von Y.
		*/
		public void setY(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _y) {
			this._y = _y;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getX() != null) {
	                if (getX().isZustand()) {
	                    datum.getUnscaledValue("X").setText(getX().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("X").set(getX().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getY() != null) {
	                if (getY().isZustand()) {
	                    datum.getUnscaledValue("Y").setText(getY().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Y").set(getY().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setX(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("X").
								longValue
						()));
				// GanzzahlAttributTyp
						setY(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Y").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlPunkt clone() {
		AtlPunkt klon = new AtlPunkt();
		
						klon.setX(getX());
						klon.setY(getY());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
