/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenstruktur, die die allgemeine Reaktion
					des Application
					Managers auf einen Fehler in einer überwachten
					Anwendung beschreibt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlManagedApplicationFehlerReaktion implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _betriebsmeldung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _script
			;
			private String
			 _befehlszeile
			= new String
			()
			;
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Betriebsmeldung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getBetriebsmeldung() {
			return _betriebsmeldung;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _betriebsmeldung der neue Wert von Betriebsmeldung.
		*/
		public void setBetriebsmeldung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _betriebsmeldung) {
			this._betriebsmeldung = _betriebsmeldung;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Script.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getScript() {
			return _script;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _script der neue Wert von Script.
		*/
		public void setScript(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _script) {
			this._script = _script;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Befehlszeile.
		*/
			public String
			 getBefehlszeile() {
			return _befehlszeile;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _befehlszeile der neue Wert von Befehlszeile.
		*/
		public void setBefehlszeile(String
		 _befehlszeile) {
			if (_befehlszeile.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._befehlszeile = _befehlszeile;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getBetriebsmeldung() != null) {
	                if (getBetriebsmeldung().isZustand()) {
	                    datum.getUnscaledValue("Betriebsmeldung").setText(getBetriebsmeldung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Betriebsmeldung").set(getBetriebsmeldung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getScript() != null) {
	                if (getScript().isZustand()) {
	                    datum.getUnscaledValue("Script").setText(getScript().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Script").set(getScript().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getBefehlszeile() != null) {
					datum.getTextValue("Befehlszeile").setText(getBefehlszeile());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Betriebsmeldung").isState()) {
							setBetriebsmeldung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Betriebsmeldung").getText()));
						} else {
						setBetriebsmeldung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Betriebsmeldung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Script").isState()) {
							setScript(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Script").getText()));
						} else {
						setScript(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Script").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setBefehlszeile(daten.getTextValue("Befehlszeile").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlManagedApplicationFehlerReaktion clone() {
		AtlManagedApplicationFehlerReaktion klon = new AtlManagedApplicationFehlerReaktion();
		
						klon.setBetriebsmeldung(getBetriebsmeldung());
						klon.setScript(getScript());
						klon.setBefehlszeile(getBefehlszeile());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
