/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Gibt die Fahrtrichtung einer Straße an.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdFahrtRichtung extends AbstractKonfigurationsDatensatz<KdFahrtRichtung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttRichtungInGrad
				 _hauptrichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 _himmelsrichtung
				;
		
			/**
			Float-Wert mit drei Nachkommastellen im Bereich
								0 ° bis
								+359,999 °, zur Darstellung von Winkeln (z.B.
								Blickrichtung,
								Himmerlsrichtung).
			<p>
			
			</p>
			
			@return der Wert von Hauptrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttRichtungInGrad
				 getHauptrichtung() {
				return _hauptrichtung;
			}
		
			/**
			Float-Wert mit drei Nachkommastellen im Bereich
								0 ° bis
								+359,999 °, zur Darstellung von Winkeln (z.B.
								Blickrichtung,
								Himmerlsrichtung).
			<p>
			
			</p>
			
			@param _hauptrichtung der neue Wert von Hauptrichtung.
			*/
			public void setHauptrichtung(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttRichtungInGrad
			 _hauptrichtung) {
				this._hauptrichtung = _hauptrichtung;
			}
		
			/**
			Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
			<p>
			
			</p>
			
			@return der Wert von Himmelsrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 getHimmelsrichtung() {
				return _himmelsrichtung;
			}
		
			/**
			Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
			<p>
			
			</p>
			
			@param _himmelsrichtung der neue Wert von Himmelsrichtung.
			*/
			public void setHimmelsrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
			 _himmelsrichtung) {
				this._himmelsrichtung = _himmelsrichtung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getHauptrichtung() != null) {
		                if (getHauptrichtung().isZustand()) {
		                    datum.getUnscaledValue("Hauptrichtung").setText(getHauptrichtung().toString());
		                } else {
							datum.
							getScaledValue
		                	("Hauptrichtung").set(getHauptrichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getHimmelsrichtung() != null) {
		                if (getHimmelsrichtung().isZustand()) {
		                    datum.getUnscaledValue("Himmelsrichtung").setText(getHimmelsrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Himmelsrichtung").set(getHimmelsrichtung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setHauptrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttRichtungInGrad
							(daten.
								getScaledValue
							("Hauptrichtung").
								doubleValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Himmelsrichtung").isState()) {
								setHimmelsrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
								.getZustand(daten.getScaledValue("Himmelsrichtung").getText()));
							} else {
							setHimmelsrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
							(daten.
								getUnscaledValue
							("Himmelsrichtung").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setHauptrichtung(getHauptrichtung());
							klon.setHimmelsrichtung(getHimmelsrichtung());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.fahrtRichtung";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdFahrtRichtung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
