/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition für eine externe Meldungsaktion.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlBcBmvExternalAction implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "Neue externe Aktion")
			private String
			 _name
			= new String
			()
			;
			@Defaultwert(wert = "Extrafenster")
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBmvAktionType
			 _aktion
			;
			@Defaultwert(wert = "Dateiname / E-Mail-Adresse / Telefonnummer eingeben")
			private String
			 _destination
			= new String
			()
			;
			@Defaultwert(wert = "30 s")
			private 	RelativerZeitstempel
			 _dauer
			;
			@Defaultwert(wert = "Information")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 _klasse
			;
			@Defaultwert(wert = "System")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
			 _typ
			;
			@Defaultwert(wert = "")
			private String
			 _filter
			= new String
			()
			;
	
		/**
		Name der Aktion.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name der Aktion.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Typ der Aktion.
		<p>
		
		</p>
		
		@return der Wert von Aktion.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBmvAktionType
			 getAktion() {
			return _aktion;
		}
	
		/**
		Typ der Aktion.
		<p>
		
		</p>
		
		@param _aktion der neue Wert von Aktion.
		*/
		public void setAktion(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBmvAktionType
		 _aktion) {
			this._aktion = _aktion;
		}
	
		/**
		Ziel-Addresse.
		<p>
		
		</p>
		
		@return der Wert von Destination.
		*/
			public String
			 getDestination() {
			return _destination;
		}
	
		/**
		Ziel-Addresse.
		<p>
		
		</p>
		
		@param _destination der neue Wert von Destination.
		*/
		public void setDestination(String
		 _destination) {
			if (_destination.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._destination = _destination;
		}
	
		/**
		Dauer der Aktion in Sekunden (bei Sound).
		<p>
		
		</p>
		
		@return der Wert von Dauer.
		*/
			public 	RelativerZeitstempel
			 getDauer() {
			return _dauer;
		}
	
		/**
		Dauer der Aktion in Sekunden (bei Sound).
		<p>
		
		</p>
		
		@param _dauer der neue Wert von Dauer.
		*/
		public void setDauer(	RelativerZeitstempel
		 _dauer) {
			this._dauer = _dauer;
		}
	
		/**
		Klasse der Meldung.
		<p>
		Hiermit ist die Klassifizierung einer Meldung in "Fatal", "Fehler", "Warnung" und "Information" möglich.
		</p>
		
		@return der Wert von Klasse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 getKlasse() {
			return _klasse;
		}
	
		/**
		Klasse der Meldung.
		<p>
		Hiermit ist die Klassifizierung einer Meldung in "Fatal", "Fehler", "Warnung" und "Information" möglich.
		</p>
		
		@param _klasse der neue Wert von Klasse.
		*/
		public void setKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
		 _klasse) {
			this._klasse = _klasse;
		}
	
		/**
		Typ der Meldung.
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
			 getTyp() {
			return _typ;
		}
	
		/**
		Typ der Meldung.
		<p>
		
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
		 _typ) {
			this._typ = _typ;
		}
	
		/**
		Ein Filtertext, der es erlaubt, nur bestimmte Meldungstexte in einer externen Aktion auszuwerten.
		<p>
		
		</p>
		
		@return der Wert von Filter.
		*/
			public String
			 getFilter() {
			return _filter;
		}
	
		/**
		Ein Filtertext, der es erlaubt, nur bestimmte Meldungstexte in einer externen Aktion auszuwerten.
		<p>
		
		</p>
		
		@param _filter der neue Wert von Filter.
		*/
		public void setFilter(String
		 _filter) {
			if (_filter.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._filter = _filter;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// GanzzahlAttributTyp
				if (getAktion() != null) {
	                if (getAktion().isZustand()) {
	                    datum.getUnscaledValue("Aktion").setText(getAktion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktion").set(getAktion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getDestination() != null) {
					datum.getTextValue("Destination").setText(getDestination());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Dauer").setMillis(getDauer().getTime());
				// GanzzahlAttributTyp
				if (getKlasse() != null) {
	                if (getKlasse().isZustand()) {
	                    datum.getUnscaledValue("Klasse").setText(getKlasse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Klasse").set(getKlasse().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTyp() != null) {
	                if (getTyp().isZustand()) {
	                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Typ").set(getTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getFilter() != null) {
					datum.getTextValue("Filter").setText(getFilter());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktion").isState()) {
							setAktion(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBmvAktionType
							.getZustand(daten.getScaledValue("Aktion").getText()));
						} else {
						setAktion(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBmvAktionType
						(daten.
							getUnscaledValue
						("Aktion").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setDestination(daten.getTextValue("Destination").getText());
				// ZeitstempelAttributTyp
					setDauer(new
						RelativerZeitstempel
						(daten.getTimeValue("Dauer").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Klasse").isState()) {
							setKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
							.getZustand(daten.getScaledValue("Klasse").getText()));
						} else {
						setKlasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
						(daten.
							getUnscaledValue
						("Klasse").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Typ").isState()) {
							setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
							.getZustand(daten.getScaledValue("Typ").getText()));
						} else {
						setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
						(daten.
							getUnscaledValue
						("Typ").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setFilter(daten.getTextValue("Filter").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcBmvExternalAction clone() {
		AtlBcBmvExternalAction klon = new AtlBcBmvExternalAction();
		
						klon.setName(getName());
						klon.setAktion(getAktion());
						klon.setDestination(getDestination());
						klon.setDauer(getDauer());
						klon.setKlasse(getKlasse());
						klon.setTyp(getTyp());
						klon.setFilter(getFilter());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
