/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Aktionstyp für Meldungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttBcBetriebsmeldungSpalte extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_0_ZEIT = new AttBcBetriebsmeldungSpalte("Zeit", 		Integer
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_1_APPLIKATIONSID = new AttBcBetriebsmeldungSpalte("ApplikationsID", 		Integer
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_2_LAUFENDENUMMER = new AttBcBetriebsmeldungSpalte("LaufendeNummer", 		Integer
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_3_APPLIKATIONSTYP = new AttBcBetriebsmeldungSpalte("ApplikationsTyp", 		Integer
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_4_APPLIKATIONSKENNUNG = new AttBcBetriebsmeldungSpalte("ApplikationsKennung", 		Integer
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_5_ID = new AttBcBetriebsmeldungSpalte("ID", 		Integer
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_6_MELDUNGSTYP = new AttBcBetriebsmeldungSpalte("MeldungsTyp", 		Integer
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_7_MELDUNGSTYPZUSATZ = new AttBcBetriebsmeldungSpalte("MeldungsTypZusatz", 		Integer
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_8_MELDUNGSKLASSE = new AttBcBetriebsmeldungSpalte("MeldungsKlasse", 		Integer
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_9_REFERENZ = new AttBcBetriebsmeldungSpalte("Referenz", 		Integer
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_10_STATUS = new AttBcBetriebsmeldungSpalte("Status", 		Integer
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_11_URLASSERBENUTZER = new AttBcBetriebsmeldungSpalte("Urlasserbenutzer", 		Integer
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_12_URLASSERURSACHE = new AttBcBetriebsmeldungSpalte("Urlasserursache", 		Integer
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_13_URLASSERVERANLASSER = new AttBcBetriebsmeldungSpalte("Urlasserveranlasser", 		Integer
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcBetriebsmeldungSpalte ZUSTAND_14_MELDUNGSTEXT = new AttBcBetriebsmeldungSpalte("MeldungsText", 		Integer
	.valueOf("14"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttBcBetriebsmeldungSpalte getZustand(final 		Integer
	 value) {
		for (AttBcBetriebsmeldungSpalte e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttBcBetriebsmeldungSpalte getZustand(final String value) {
		for (AttBcBetriebsmeldungSpalte e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttBcBetriebsmeldungSpalte> getZustaende() {
		List<AttBcBetriebsmeldungSpalte> list = new ArrayList<AttBcBetriebsmeldungSpalte>();
		list.add(ZUSTAND_0_ZEIT);
		list.add(ZUSTAND_1_APPLIKATIONSID);
		list.add(ZUSTAND_2_LAUFENDENUMMER);
		list.add(ZUSTAND_3_APPLIKATIONSTYP);
		list.add(ZUSTAND_4_APPLIKATIONSKENNUNG);
		list.add(ZUSTAND_5_ID);
		list.add(ZUSTAND_6_MELDUNGSTYP);
		list.add(ZUSTAND_7_MELDUNGSTYPZUSATZ);
		list.add(ZUSTAND_8_MELDUNGSKLASSE);
		list.add(ZUSTAND_9_REFERENZ);
		list.add(ZUSTAND_10_STATUS);
		list.add(ZUSTAND_11_URLASSERBENUTZER);
		list.add(ZUSTAND_12_URLASSERURSACHE);
		list.add(ZUSTAND_13_URLASSERVERANLASSER);
		list.add(ZUSTAND_14_MELDUNGSTEXT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut BitCtrl MeldungslistenSpalte.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttBcBetriebsmeldungSpalte(final 		Integer
	 value) {
		super(value);
	}
	
	private AttBcBetriebsmeldungSpalte(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
