/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert eine Farbe aus den Grundfarben Rot, Grün und Blau.
<p>
Die Farbdefinition hält sich an das übliche RGB-Schema, die resultierende Farbe wird aus den
					Grundfarben Rot, Grün und Blau zusammengesetzt. Jede Grundfarbe kann einen Anteil von 0 bis 255 annehmen.
					Entspricht org.eclipse.swt.graphics.RGB
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlRgb implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
			 _rot
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
			 _gruen
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
			 _blau
			;
	
		/**
		Eine allgemeine ganze Zahl mit dem Wertebereich 0 bis 255.
		<p>
		
		</p>
		
		@return der Wert von Rot.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
			 getRot() {
			return _rot;
		}
	
		/**
		Eine allgemeine ganze Zahl mit dem Wertebereich 0 bis 255.
		<p>
		
		</p>
		
		@param _rot der neue Wert von Rot.
		*/
		public void setRot(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
		 _rot) {
			this._rot = _rot;
		}
	
		/**
		Eine allgemeine ganze Zahl mit dem Wertebereich 0 bis 255.
		<p>
		
		</p>
		
		@return der Wert von Gruen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
			 getGruen() {
			return _gruen;
		}
	
		/**
		Eine allgemeine ganze Zahl mit dem Wertebereich 0 bis 255.
		<p>
		
		</p>
		
		@param _gruen der neue Wert von Gruen.
		*/
		public void setGruen(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
		 _gruen) {
			this._gruen = _gruen;
		}
	
		/**
		Eine allgemeine ganze Zahl mit dem Wertebereich 0 bis 255.
		<p>
		
		</p>
		
		@return der Wert von Blau.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
			 getBlau() {
			return _blau;
		}
	
		/**
		Eine allgemeine ganze Zahl mit dem Wertebereich 0 bis 255.
		<p>
		
		</p>
		
		@param _blau der neue Wert von Blau.
		*/
		public void setBlau(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
		 _blau) {
			this._blau = _blau;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getRot() != null) {
	                if (getRot().isZustand()) {
	                    datum.getUnscaledValue("Rot").setText(getRot().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Rot").set(getRot().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGruen() != null) {
	                if (getGruen().isZustand()) {
	                    datum.getUnscaledValue("Grün").setText(getGruen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Grün").set(getGruen().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBlau() != null) {
	                if (getBlau().isZustand()) {
	                    datum.getUnscaledValue("Blau").setText(getBlau().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Blau").set(getBlau().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setRot(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
						(daten.
							getUnscaledValue
						("Rot").
								shortValue
						()));
				// GanzzahlAttributTyp
						setGruen(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
						(daten.
							getUnscaledValue
						("Grün").
								shortValue
						()));
				// GanzzahlAttributTyp
						setBlau(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttUnsignedByte
						(daten.
							getUnscaledValue
						("Blau").
								shortValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRgb clone() {
		AtlRgb klon = new AtlRgb();
		
						klon.setRot(getRot());
						klon.setGruen(getGruen());
						klon.setBlau(getBlau());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
