/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter für die Applikation, welche die externen Helligkeitswerte bereitstellt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdParameterExterneHelligkeit extends AbstractParameterDatensatz<PdParameterExterneHelligkeit.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
				 _artDerExternenHelligkeitsQuelle
				;
				private 	RelativerZeitstempel
				 _t
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit
				 _lokalerHelligkeitsSensor
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				 _aspekt
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Definiert die Art der externen Helligkeitsquelle.
			<p>
			
			</p>
			
			@return der Wert von ArtDerExternenHelligkeitsQuelle.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
				 getArtDerExternenHelligkeitsQuelle() {
				return _artDerExternenHelligkeitsQuelle;
			}
		
			/**
			Definiert die Art der externen Helligkeitsquelle.
			<p>
			
			</p>
			
			@param _artDerExternenHelligkeitsQuelle der neue Wert von ArtDerExternenHelligkeitsQuelle.
			*/
			public void setArtDerExternenHelligkeitsQuelle(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
			 _artDerExternenHelligkeitsQuelle) {
				this._artDerExternenHelligkeitsQuelle = _artDerExternenHelligkeitsQuelle;
			}
		
			/**
			Intervalldauer, mit dem der Wert erfasst wurde.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer, mit dem der Wert erfasst wurde.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.ufdsHelligkeit (Optionale Referenzierung erlaubt).
			<p>
			
			</p>
			
			@return der Wert von LokalerHelligkeitsSensor.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit
				 getLokalerHelligkeitsSensor() {
				return _lokalerHelligkeitsSensor;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.ufdsHelligkeit (Optionale Referenzierung erlaubt).
			<p>
			
			</p>
			
			@param _lokalerHelligkeitsSensor der neue Wert von LokalerHelligkeitsSensor.
			*/
			public void setLokalerHelligkeitsSensor(	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit
			 _lokalerHelligkeitsSensor) {
				this._lokalerHelligkeitsSensor = _lokalerHelligkeitsSensor;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.aspekt (Optionale Referenzierung erlaubt).
			<p>
			
			</p>
			
			@return der Wert von Aspekt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				 getAspekt() {
				return _aspekt;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.aspekt (Optionale Referenzierung erlaubt).
			<p>
			
			</p>
			
			@param _aspekt der neue Wert von Aspekt.
			*/
			public void setAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspekt) {
				this._aspekt = _aspekt;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getArtDerExternenHelligkeitsQuelle() != null) {
		                if (getArtDerExternenHelligkeitsQuelle().isZustand()) {
		                    datum.getUnscaledValue("ArtDerExternenHelligkeitsQuelle").setText(getArtDerExternenHelligkeitsQuelle().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ArtDerExternenHelligkeitsQuelle").set(getArtDerExternenHelligkeitsQuelle().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// ObjektReferenzAttributTyp
						final Object soLokalerHelligkeitsSensor = getLokalerHelligkeitsSensor();
						final SystemObject tmpLokalerHelligkeitsSensor;
							if (soLokalerHelligkeitsSensor instanceof SystemObject) {
								tmpLokalerHelligkeitsSensor = (SystemObject)soLokalerHelligkeitsSensor;
							} else if(soLokalerHelligkeitsSensor instanceof SystemObjekt){
								tmpLokalerHelligkeitsSensor = ((SystemObjekt)soLokalerHelligkeitsSensor).getSystemObject();
							} else{
								tmpLokalerHelligkeitsSensor = null;
							}
						datum.getReferenceValue("LokalerHelligkeitsSensor").setSystemObject(tmpLokalerHelligkeitsSensor);
					// ObjektReferenzAttributTyp
						final Object soAspekt = getAspekt();
						final SystemObject tmpAspekt;
							if (soAspekt instanceof SystemObject) {
								tmpAspekt = (SystemObject)soAspekt;
							} else if(soAspekt instanceof SystemObjekt){
								tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
							} else{
								tmpAspekt = null;
							}
						datum.getReferenceValue("Aspekt").setSystemObject(tmpAspekt);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ArtDerExternenHelligkeitsQuelle").isState()) {
								setArtDerExternenHelligkeitsQuelle(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
								.getZustand(daten.getScaledValue("ArtDerExternenHelligkeitsQuelle").getText()));
							} else {
							setArtDerExternenHelligkeitsQuelle(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
							(daten.
								getUnscaledValue
							("ArtDerExternenHelligkeitsQuelle").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// ObjektReferenzAttributTyp
						final long idLokalerHelligkeitsSensor = daten.getReferenceValue("LokalerHelligkeitsSensor").getId();
						final SystemObjekt tmpLokalerHelligkeitsSensor;
						if (idLokalerHelligkeitsSensor == 0) {
							tmpLokalerHelligkeitsSensor = null;
						} else {
							final SystemObject soLokalerHelligkeitsSensor = factory.getDav().getDataModel().getObject(idLokalerHelligkeitsSensor);
							if (soLokalerHelligkeitsSensor == null) {
									tmpLokalerHelligkeitsSensor = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl.UfdsHelligkeitUngueltig(idLokalerHelligkeitsSensor);
							} else {
								tmpLokalerHelligkeitsSensor = factory.getModellobjekt(soLokalerHelligkeitsSensor);
							}
						}
						setLokalerHelligkeitsSensor((	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit
						) tmpLokalerHelligkeitsSensor);
					// ObjektReferenzAttributTyp
						final long idAspekt = daten.getReferenceValue("Aspekt").getId();
						final SystemObjekt tmpAspekt;
						if (idAspekt == 0) {
							tmpAspekt = null;
						} else {
							final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
							if (soAspekt == null) {
									tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
							} else {
								tmpAspekt = factory.getModellobjekt(soAspekt);
							}
						}
						setAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
						) tmpAspekt);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setArtDerExternenHelligkeitsQuelle(getArtDerExternenHelligkeitsQuelle());
							klon.setT(getT());
							klon.setLokalerHelligkeitsSensor(getLokalerHelligkeitsSensor());
							klon.setAspekt(getAspekt());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parameterExterneHelligkeit";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdParameterExterneHelligkeit(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
