/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenstruktur, die die Reaktion einer DE beschreibt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcSimDe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AttBcSimDeReaktion
			 _art
			;
			private String
			 _wert
			= new String
			()
			;
	
		/**
		Definiert die möglichen Reaktionen einer DE auf einen Stellbefehl.
		<p>
		
		</p>
		
		@return der Wert von Art.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AttBcSimDeReaktion
			 getArt() {
			return _art;
		}
	
		/**
		Definiert die möglichen Reaktionen einer DE auf einen Stellbefehl.
		<p>
		
		</p>
		
		@param _art der neue Wert von Art.
		*/
		public void setArt(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AttBcSimDeReaktion
		 _art) {
			this._art = _art;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public String
			 getWert() {
			return _wert;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _wert der neue Wert von Wert.
		*/
		public void setWert(String
		 _wert) {
			if (_wert.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._wert = _wert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getArt() != null) {
	                if (getArt().isZustand()) {
	                    datum.getUnscaledValue("Art").setText(getArt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Art").set(getArt().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getWert() != null) {
					datum.getTextValue("Wert").setText(getWert());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Art").isState()) {
							setArt(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AttBcSimDeReaktion
							.getZustand(daten.getScaledValue("Art").getText()));
						} else {
						setArt(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AttBcSimDeReaktion
						(daten.
							getUnscaledValue
						("Art").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setWert(daten.getTextValue("Wert").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcSimDe clone() {
		AtlBcSimDe klon = new AtlBcSimDe();
		
						klon.setArt(getArt());
						klon.setWert(getWert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
