/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert die möglichen Reaktionen einer DE auf einen Stellbefehl.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttBcSimDeReaktion extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcSimDeReaktion ZUSTAND_1N_UNBEKANNT = new AttBcSimDeReaktion("Unbekannt", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcSimDeReaktion ZUSTAND_0_OK = new AttBcSimDeReaktion("OK", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcSimDeReaktion ZUSTAND_1_VERZOEGERT = new AttBcSimDeReaktion("Verzögert", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcSimDeReaktion ZUSTAND_2_TIMEOUT = new AttBcSimDeReaktion("Timeout", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcSimDeReaktion ZUSTAND_3_NEGATIVE_QUITTUNG = new AttBcSimDeReaktion("Negative Quittung", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcSimDeReaktion ZUSTAND_4_DE_FEHLER = new AttBcSimDeReaktion("DE-Fehler", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttBcSimDeReaktion getZustand(final 		Byte
	 value) {
		for (AttBcSimDeReaktion e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttBcSimDeReaktion getZustand(final String value) {
		for (AttBcSimDeReaktion e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttBcSimDeReaktion> getZustaende() {
		List<AttBcSimDeReaktion> list = new ArrayList<AttBcSimDeReaktion>();
		list.add(ZUSTAND_1N_UNBEKANNT);
		list.add(ZUSTAND_0_OK);
		list.add(ZUSTAND_1_VERZOEGERT);
		list.add(ZUSTAND_2_TIMEOUT);
		list.add(ZUSTAND_3_NEGATIVE_QUITTUNG);
		list.add(ZUSTAND_4_DE_FEHLER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut BitCtrl Simulations-Reaktion einer DE.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttBcSimDeReaktion(final 		Byte
	 value) {
		super(value);
	}
	
	private AttBcSimDeReaktion(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
