/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein einzelnes Mapping Liste von DE WZG &lt;--&gt; UfdsHelligkeit.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlHelligkeitsSteuerungEinzelDe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
			> _clusterkanaele = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlClusterKanalVorgaben
			 _vorgaben
			= new de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlClusterKanalVorgaben
			()
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.deWzg.
		<p>
		
		</p>
		
		@return der Wert von Clusterkanaele.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
			> getClusterkanaele() {
			return _clusterkanaele;
		}
	
	
		/**
		Parametriert die Clusterkanäle, die nicht implizit über die globalen Vorgaben
						versorgt sind (Überschreiben).
		<p>
		
		</p>
		
		@return der Wert von Vorgaben.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlClusterKanalVorgaben
			 getVorgaben() {
			return _vorgaben;
		}
	
		/**
		Parametriert die Clusterkanäle, die nicht implizit über die globalen Vorgaben
						versorgt sind (Überschreiben).
		<p>
		
		</p>
		
		@param _vorgaben der neue Wert von Vorgaben.
		*/
		public void setVorgaben(de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlClusterKanalVorgaben
		 _vorgaben) {
			this._vorgaben = _vorgaben;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayClusterkanaele = datum.getReferenceArray("Clusterkanäle");
					arrayClusterkanaele.setLength(getClusterkanaele().size());
					for (int i = 0; i < arrayClusterkanaele.getLength(); ++i) {
						final Object soClusterkanaele = getClusterkanaele().get(i);
						final SystemObject tmpClusterkanaele;
						if (soClusterkanaele instanceof SystemObject) {
							tmpClusterkanaele = (SystemObject)soClusterkanaele;
						} else if(soClusterkanaele instanceof SystemObjekt){
							tmpClusterkanaele = ((SystemObjekt)soClusterkanaele).getSystemObject();
						} else{
							tmpClusterkanaele = null;
						}
						arrayClusterkanaele.getReferenceValue(i).setSystemObject(tmpClusterkanaele);
					}
				// AttributListenDefinition
					getVorgaben().bean2Atl(datum.getItem("Vorgaben"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayClusterkanaele = daten.getReferenceArray("Clusterkanäle");
					for (int i = 0; i < arrayClusterkanaele.getLength(); ++i) {
						final long idClusterkanaele = daten.getReferenceArray("Clusterkanäle").getReferenceValue(i).getId();
						final SystemObjekt tmpClusterkanaele;
						if (idClusterkanaele == 0) {
							tmpClusterkanaele = null;
						} else {
							final SystemObject soClusterkanaele = factory.getDav().getDataModel().getObject(idClusterkanaele);
							if (soClusterkanaele == null) {
									tmpClusterkanaele = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.impl.DeWzgUngueltig(idClusterkanaele);
							} else {
								tmpClusterkanaele = factory.getModellobjekt(soClusterkanaele);
							}
						}
							getClusterkanaele().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
							) tmpClusterkanaele);
					}
				// AttributListenDefinition
					getVorgaben().atl2Bean(daten.getItem("Vorgaben"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlHelligkeitsSteuerungEinzelDe clone() {
		AtlHelligkeitsSteuerungEinzelDe klon = new AtlHelligkeitsSteuerungEinzelDe();
		
					klon._clusterkanaele = getClusterkanaele().clone();
						klon._vorgaben = getVorgaben().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
