/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein Eintrag in einer Tabelle, der einem Umfelddatensensor
					ein Gewicht zuweist.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlEintragTabelleUfdsGewicht implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
			 _umfelddatenSensor
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsGewicht
			 _gewicht
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.umfeldDatenSensor.
		<p>
		
		</p>
		
		@return der Wert von UmfelddatenSensor.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
			 getUmfelddatenSensor() {
			return _umfelddatenSensor;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.umfeldDatenSensor.
		<p>
		
		</p>
		
		@param _umfelddatenSensor der neue Wert von UmfelddatenSensor.
		*/
		public void setUmfelddatenSensor(	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
		 _umfelddatenSensor) {
			this._umfelddatenSensor = _umfelddatenSensor;
		}
	
		/**
		Definiert das Gewicht des Umfelddaten-Sensors innerhalb
							einer Gruppe typgleicher Sensoren.
		<p>
		Die Applikation BitCtrl Eventgenerator Verkehr fasst
							mehrere Umfelddaten-Sensoren
							zusammen, um eine sichere Aussage über
							den wirklichen Zustand zu gewinnen.
		</p>
		
		@return der Wert von Gewicht.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsGewicht
			 getGewicht() {
			return _gewicht;
		}
	
		/**
		Definiert das Gewicht des Umfelddaten-Sensors innerhalb
							einer Gruppe typgleicher Sensoren.
		<p>
		Die Applikation BitCtrl Eventgenerator Verkehr fasst
							mehrere Umfelddaten-Sensoren
							zusammen, um eine sichere Aussage über
							den wirklichen Zustand zu gewinnen.
		</p>
		
		@param _gewicht der neue Wert von Gewicht.
		*/
		public void setGewicht(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsGewicht
		 _gewicht) {
			this._gewicht = _gewicht;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soUmfelddatenSensor = getUmfelddatenSensor();
					final SystemObject tmpUmfelddatenSensor;
						if (soUmfelddatenSensor instanceof SystemObject) {
							tmpUmfelddatenSensor = (SystemObject)soUmfelddatenSensor;
						} else if(soUmfelddatenSensor instanceof SystemObjekt){
							tmpUmfelddatenSensor = ((SystemObjekt)soUmfelddatenSensor).getSystemObject();
						} else{
							tmpUmfelddatenSensor = null;
						}
					datum.getReferenceValue("UmfelddatenSensor").setSystemObject(tmpUmfelddatenSensor);
				// GanzzahlAttributTyp
				if (getGewicht() != null) {
	                if (getGewicht().isZustand()) {
	                    datum.getUnscaledValue("Gewicht").setText(getGewicht().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Gewicht").set(getGewicht().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idUmfelddatenSensor = daten.getReferenceValue("UmfelddatenSensor").getId();
					final SystemObjekt tmpUmfelddatenSensor;
					if (idUmfelddatenSensor == 0) {
						tmpUmfelddatenSensor = null;
					} else {
						final SystemObject soUmfelddatenSensor = factory.getDav().getDataModel().getObject(idUmfelddatenSensor);
						if (soUmfelddatenSensor == null) {
								tmpUmfelddatenSensor = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl.UmfeldDatenSensorUngueltig(idUmfelddatenSensor);
						} else {
							tmpUmfelddatenSensor = factory.getModellobjekt(soUmfelddatenSensor);
						}
					}
					setUmfelddatenSensor((	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
					) tmpUmfelddatenSensor);
				// GanzzahlAttributTyp
						setGewicht(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsGewicht
						(daten.
							getUnscaledValue
						("Gewicht").
								shortValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlEintragTabelleUfdsGewicht clone() {
		AtlEintragTabelleUfdsGewicht klon = new AtlEintragTabelleUfdsGewicht();
		
						klon.setUmfelddatenSensor(getUmfelddatenSensor());
						klon.setGewicht(getGewicht());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
