/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
public class AtlDzstObjektMeldung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _objekt
			;
			private String
			 _meldung
			= new String
			()
			;
	
		/**
		Attribut zur Referenzierung von beliebigen Objekten.
		<p>
		
		</p>
		
		@return der Wert von Objekt.
		*/
			public 	Object
			 getObjekt() {
			return _objekt;
		}
	
		/**
		Attribut zur Referenzierung von beliebigen Objekten.
		<p>
		
		</p>
		
		@param _objekt der neue Wert von Objekt.
		*/
		public void setObjekt(	Object
		 _objekt) {
			this._objekt = _objekt;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Meldung.
		*/
			public String
			 getMeldung() {
			return _meldung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _meldung der neue Wert von Meldung.
		*/
		public void setMeldung(String
		 _meldung) {
			if (_meldung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._meldung = _meldung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soObjekt = getObjekt();
					final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
					datum.getReferenceValue("Objekt").setSystemObject(tmpObjekt);
				// ZeichenkettenAttributTyp
				if (getMeldung() != null) {
					datum.getTextValue("Meldung").setText(getMeldung());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idObjekt = daten.getReferenceValue("Objekt").getId();
					final SystemObjekt tmpObjekt;
					if (idObjekt == 0) {
						tmpObjekt = null;
					} else {
						final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
						if (soObjekt == null) {
								tmpObjekt = new BaseUngueltigesSystemObjekt(idObjekt);
						} else {
							tmpObjekt = factory.getModellobjekt(soObjekt);
						}
					}
					setObjekt((	Object
					) tmpObjekt);
				// ZeichenkettenAttributTyp
					setMeldung(daten.getTextValue("Meldung").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDzstObjektMeldung clone() {
		AtlDzstObjektMeldung klon = new AtlDzstObjektMeldung();
		
						klon.setObjekt(getObjekt());
						klon.setMeldung(getMeldung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
