/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kennungen fuer den Baustellenstatus einer Dauerzählstelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class AttBaustellenStatus extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaustellenStatus ZUSTAND_0_KEINE_BAUSTELLE = new AttBaustellenStatus("Keine Baustelle", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaustellenStatus ZUSTAND_1_BAUSTELLE_AKTIV = new AttBaustellenStatus("Baustelle aktiv", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaustellenStatus ZUSTAND_2_BAUSTELLE_LAEUFT_AUS = new AttBaustellenStatus("Baustelle läuft aus", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaustellenStatus ZUSTAND_3_BAUSTELLE_GEPLANT = new AttBaustellenStatus("Baustelle geplant", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttBaustellenStatus getZustand(final 		Byte
	 value) {
		for (AttBaustellenStatus e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttBaustellenStatus getZustand(final String value) {
		for (AttBaustellenStatus e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttBaustellenStatus> getZustaende() {
		List<AttBaustellenStatus> list = new ArrayList<AttBaustellenStatus>();
		list.add(ZUSTAND_0_KEINE_BAUSTELLE);
		list.add(ZUSTAND_1_BAUSTELLE_AKTIV);
		list.add(ZUSTAND_2_BAUSTELLE_LAEUFT_AUS);
		list.add(ZUSTAND_3_BAUSTELLE_GEPLANT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut DzBaustellenStatus.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttBaustellenStatus(final 		Byte
	 value) {
		super(value);
	}
	
	private AttBaustellenStatus(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
