/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenendgerätekanal der Funktionsgruppe 1 mit Typ79 (Version 24).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class DeLveTyp79Impl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.objekte.DeLveTyp79 { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public DeLveTyp79Impl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public DeLveTyp79Impl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein DeLveTyp79.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsSveBetriebsParameter getPdTlsSveBetriebsParameter() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsSveBetriebsParameter.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKrad getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKrad() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKrad.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen getPdTlsBetriebsMeldungErzeugen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveKfzEinzelDaten getOdTlsLveKfzEinzelDaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveKfzEinzelDaten.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSattelKfz getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSattelKfz() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSattelKfz.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwAe getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwAe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwAe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenPkwAe getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenPkwAe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenPkwAe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe getKdDe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDeLve getKdDeLve() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDeLve.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung getPdTlsGloKanalSteuerung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBPA getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBPA() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBPA.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwA getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwA() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwA.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwG getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwG() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwG.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveBetriebsParameter getPdTlsLveBetriebsParameter() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveBetriebsParameter.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf getOdTlsGloDeBlockAbruf() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLvePositiveQuittung getOdTlsLvePositiveQuittung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLvePositiveQuittung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden getOdTlsGloDeBlockSenden() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkw getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkw() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkw.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler getOdTlsGloDeFehler() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell getPdTlsPassivierungUebernahmeLogischesModell() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwA getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwA() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwA.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten getOdTlsGloGeographischeKenndaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgaenzendeDeFehlerMeldung getOdTlsLveErgaenzendeDeFehlerMeldung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgaenzendeDeFehlerMeldung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkw getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkw() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkw.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveNegativeQuittung getOdTlsLveNegativeQuittung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveNegativeQuittung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveAbrufPufferInhalt getOdTlsLveAbrufPufferInhalt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveAbrufPufferInhalt.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwK getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwK() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwK.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLVo getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLVo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLVo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSGV getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSGV() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSGV.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion0Bis4 getOdTlsLveErgebnisMeldungVersion0Bis4() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion0Bis4.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLfw getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLfw() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLfw.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion24 getOdTlsLveErgebnisMeldungVersion24() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion24.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion10Bis23 getOdTlsLveErgebnisMeldungVersion10Bis23() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion10Bis23.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsSveErgebnisMeldungVersion0Bis1 getOdTlsSveErgebnisMeldungVersion0Bis1() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsSveErgebnisMeldungVersion0Bis1.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBus getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBus.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfz getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfz() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfz.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfzNk getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfzNk() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfzNk.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse getOdTlsFehlerAnalyse() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwAe getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwAe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwAe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
