/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Güteinformationen zum Wert (Güte und Verfahren, welches zur Güteermittlung verwendet wurde).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlGuete implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 _index
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteVerfahren
			 _verfahren
			;
	
		/**
		Güte des betrachteten Wertes.
		<p>
		
		</p>
		
		@return der Wert von Index.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 getIndex() {
			return _index;
		}
	
		/**
		Güte des betrachteten Wertes.
		<p>
		
		</p>
		
		@param _index der neue Wert von Index.
		*/
		public void setIndex(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
		 _index) {
			this._index = _index;
		}
	
		/**
		Berechnungsverfahren, mit dem die Güte ermittelt wurde.
		<p>
		
		</p>
		
		@return der Wert von Verfahren.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteVerfahren
			 getVerfahren() {
			return _verfahren;
		}
	
		/**
		Berechnungsverfahren, mit dem die Güte ermittelt wurde.
		<p>
		
		</p>
		
		@param _verfahren der neue Wert von Verfahren.
		*/
		public void setVerfahren(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteVerfahren
		 _verfahren) {
			this._verfahren = _verfahren;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getIndex() != null) {
	                if (getIndex().isZustand()) {
	                    datum.getUnscaledValue("Index").setText(getIndex().toString());
	                } else {
						datum.
						getScaledValue
	                	("Index").set(getIndex().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVerfahren() != null) {
	                if (getVerfahren().isZustand()) {
	                    datum.getUnscaledValue("Verfahren").setText(getVerfahren().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Verfahren").set(getVerfahren().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Index").isState()) {
							setIndex(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
							.getZustand(daten.getScaledValue("Index").getText()));
						} else {
						setIndex(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
						(daten.
							getScaledValue
						("Index").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Verfahren").isState()) {
							setVerfahren(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteVerfahren
							.getZustand(daten.getScaledValue("Verfahren").getText()));
						} else {
						setVerfahren(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteVerfahren
						(daten.
							getUnscaledValue
						("Verfahren").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGuete clone() {
		AtlGuete klon = new AtlGuete();
		
						klon.setIndex(getIndex());
						klon.setVerfahren(getVerfahren());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
