/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kurzzeitintervall bis zu einer Stunde, aber nur ganzzahlige Teiler von 1h.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttKurzzeitIntervallAnteilStunde extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttKurzzeitIntervallAnteilStunde ZUSTAND_5__5_MINUTEN = new AttKurzzeitIntervallAnteilStunde("5 Minuten", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttKurzzeitIntervallAnteilStunde ZUSTAND_10__10_MINUTEN = new AttKurzzeitIntervallAnteilStunde("10 Minuten", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttKurzzeitIntervallAnteilStunde ZUSTAND_15__15_MINUTEN = new AttKurzzeitIntervallAnteilStunde("15 Minuten", 		Byte
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttKurzzeitIntervallAnteilStunde ZUSTAND_30__30_MINUTEN = new AttKurzzeitIntervallAnteilStunde("30 Minuten", 		Byte
	.valueOf("30"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttKurzzeitIntervallAnteilStunde ZUSTAND_60__1_STUNDE = new AttKurzzeitIntervallAnteilStunde("1 Stunde", 		Byte
	.valueOf("60"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKurzzeitIntervallAnteilStunde getZustand(final 		Byte
	 value) {
		for (AttKurzzeitIntervallAnteilStunde e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKurzzeitIntervallAnteilStunde getZustand(final String value) {
		for (AttKurzzeitIntervallAnteilStunde e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKurzzeitIntervallAnteilStunde> getZustaende() {
		List<AttKurzzeitIntervallAnteilStunde> list = new ArrayList<AttKurzzeitIntervallAnteilStunde>();
		list.add(ZUSTAND_5__5_MINUTEN);
		list.add(ZUSTAND_10__10_MINUTEN);
		list.add(ZUSTAND_15__15_MINUTEN);
		list.add(ZUSTAND_30__30_MINUTEN);
		list.add(ZUSTAND_60__1_STUNDE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KurzzeitIntervallAnteilStunde.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKurzzeitIntervallAnteilStunde(final 		Byte
	 value) {
		super(value);
	}
	
	private AttKurzzeitIntervallAnteilStunde(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
